#include "Python.h"
#include <orb/orbit.h>
#include "../CORBAmodule/CORBAmodule.h"

/*#define checkCORBA(ev) \
  if (ev._major != CORBA_NO_EXCEPTION) {\
  fprintf(stderr, "Exception: %s\n", CORBA_exception_id(&(ev)));\
  }*/
#define checkCORBA(ev) \
  if (ev._major != CORBA_NO_EXCEPTION) { \
    PyErr_SetString(ErrorObject, CORBA_exception_id(&(ev))); \
    CORBA_exception_init(&(ev)); \
    return NULL; \
  }


static PyObject *ErrorObject;
static PyObject *Object_cast;

typedef struct {
	void	*_private;
	void	*vepv;
} GenericServant;

typedef struct {
	PyObject_HEAD
	GenericServant	servant;
} ServantObject;

/* Begin POAManager object */

static PyObject *ErrorObject;

typedef struct {
	PyObject_HEAD
	PortableServer_POAManager	ob;
	CORBA_Environment	ev;
} POAManagerObject;

staticforward PyTypeObject POAManager_Type;

#define POAManagerObject_Check(v)	((v)->ob_type == &POAManager_Type)

static POAManagerObject *
POAManager2Object(object)
	PortableServer_POAManager object;
{
	POAManagerObject *self;
	self = PyObject_NEW(POAManagerObject, &POAManager_Type);
	if (self == NULL)
		return NULL;
	CORBA_exception_init(&(self->ev));
	self->ob = object;
	return self;
}

/* POAManager methods */

static void
POAManager_dealloc(self)
	POAManagerObject *self;
{
	PyMem_DEL(self);
}

static PyObject *
POAManager_activate(self, args)
	POAManagerObject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	PortableServer_POAManager_activate(self->ob, &(self->ev));
	checkCORBA(self->ev);
	/* XXX check exception */
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
POAManager_hold_requests(self, args)
	POAManagerObject *self;
	PyObject *args;
{
	int wait_for_condition;
	if (!PyArg_ParseTuple(args, "i", &wait_for_condition))
		return NULL;
	if (wait_for_condition) {
		PortableServer_POAManager_hold_requests(self->ob, (CORBA_boolean) 1,
		  &(self->ev));
	} else {
		PortableServer_POAManager_hold_requests(self->ob, (CORBA_boolean) 0,
		  &(self->ev));
	}
	checkCORBA(self->ev);
	/* XXX check exception */
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
POAManager_discard_requests(self, args)
	POAManagerObject *self;
	PyObject *args;
{
	int wait_for_condition;
	if (!PyArg_ParseTuple(args, "i", &wait_for_condition))
		return NULL;
	if (wait_for_condition) {
		PortableServer_POAManager_discard_requests(self->ob, (CORBA_boolean) 1,
		  &(self->ev));
	} else {
		PortableServer_POAManager_discard_requests(self->ob, (CORBA_boolean) 0,
		  &(self->ev));
	}
	checkCORBA(self->ev);
	/* XXX check exception */
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
POAManager_deactivate(self, args)
	POAManagerObject *self;
	PyObject *args;
{
	int etherealize_objects, wait_for_completion;
	if (!PyArg_ParseTuple(args,"ii",&etherealize_objects,&wait_for_completion))
		return NULL;
	if (etherealize_objects)
		etherealize_objects = 1;
	if (wait_for_completion)
		wait_for_completion = 1;
	PortableServer_POAManager_deactivate(self->ob,
	  (CORBA_boolean) etherealize_objects, (CORBA_boolean) wait_for_completion,
	  &(self->ev));
	checkCORBA(self->ev);
	/* XXX check exception */
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef POAManager_methods[] = {
	{"activate",	(PyCFunction)POAManager_activate,	1},
	{"hold_requests",	(PyCFunction)POAManager_hold_requests,	1},
	{"discard_requests",	(PyCFunction)POAManager_discard_requests,	1},
	{"deactivate",	(PyCFunction)POAManager_deactivate,	1},
	{NULL,		NULL}		/* sentinel */
};

static PyObject *
POAManager_getattr(self, name)
	POAManagerObject *self;
	char *name;
{
	return Py_FindMethod(POAManager_methods, (PyObject *)self, name);
}

static int
POAManager_setattr(self, name, v)
	POAManagerObject *self;
	char *name;
	PyObject *v;
{
	return -1;
}

statichere PyTypeObject POAManager_Type = {
	/* The ob_type field must be initialized in the module init function
	 * to be portable to Windows without using C++. */
	PyObject_HEAD_INIT(NULL)
	0,			/*ob_size*/
	"POAManager",			/*tp_name*/
	sizeof(POAManagerObject),	/*tp_basicsize*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)POAManager_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)POAManager_getattr, /*tp_getattr*/
	(setattrfunc)POAManager_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

/* End POAManager object */
/* Begin POA */
typedef struct {
	PyObject_HEAD
	PortableServer_POA	ob;
	CORBA_Environment	ev;
} POAObject;

staticforward PyTypeObject POA_Type;

#define POAObject_Check(v)	((v)->ob_type == &POA_Type)

static POAObject *
POA2Object(object)
	PortableServer_POA object;
{
	POAObject *self;
	self = PyObject_NEW(POAObject, &POA_Type);
	if (self == NULL) {
		return NULL;
	}
	CORBA_exception_init(&(self->ev));
	self->ob = object;
	return self;
}

/* POA methods */

static void
POA_dealloc(self)
	POAObject *self;
{
	PyMem_DEL(self);
}

static PyObject *
POA_activate_object(self, args)
	POAObject *self;
	PyObject *args;
{
	PortableServer_ObjectId	*obid;
	ServantObject *servant;
	if (!PyArg_ParseTuple(args, "O", &servant))
		return NULL;
	obid = PortableServer_POA_activate_object(self->ob,
	    &(servant->servant), &(self->ev));
	checkCORBA(self->ev);
	/* XXX check exception */
	return (Py_BuildValue("s#", obid->_buffer, obid->_length));
}

static PyObject *
POA_activate_object_with_id(self, args)
	POAObject *self;
	PyObject *args;
{
	ServantObject *servant;
	PortableServer_ObjectId *obid;

	obid = (PortableServer_ObjectId *) CORBA_sequence_octet__alloc();
	/* XXX figure out who owns buffer */
	if (!PyArg_ParseTuple(args, "s#O",
	   &(obid->_buffer), &(obid->_length), &servant))
		return NULL;
	PortableServer_POA_activate_object_with_id(self->ob,
	   obid, &(servant->servant), &(self->ev));
	checkCORBA(self->ev);
	/* XXX check exception */
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
POA_servant_to_reference(self, args)
	POAObject *self;
	PyObject *args;
{
	CORBA_Object	reference;
	PyObject	*tmpval, *retval;
	ServantObject *servant;

	if (!PyArg_ParseTuple(args, "O", &servant))
		return NULL;
	reference = PortableServer_POA_servant_to_reference(self->ob,
	   &(servant->servant), &(self->ev));
	checkCORBA(self->ev);
	if (reference == CORBA_OBJECT_NIL) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	tmpval = (PyObject *) POA2Object(reference);
	retval = PyObject_CallFunction(Object_cast, "O", tmpval);
	Py_XDECREF(tmpval);
	return (retval);
}

static PyMethodDef POA_methods[] = {
	{"activate_object",	(PyCFunction)POA_activate_object,	1},
	{"activate_object_with_id",	(PyCFunction)POA_activate_object_with_id,	1},
	{"servant_to_reference",	(PyCFunction)POA_servant_to_reference,	1},
	{NULL,		NULL}		/* sentinel */
};

static PyObject *
POA_getattr(self, name)
	POAObject *self;
	char *name;
{
	if (!strcmp(name, "the_name")) {
		char *the_name;
		the_name = PortableServer_POA__get_the_name(self->ob, &(self->ev));
	checkCORBA(self->ev);
		/* XXX check exception */
		return PyString_FromString((const char *) the_name);
	} else if (!strcmp(name, "the_POAManager")) {
		PortableServer_POAManager the_manager;
		the_manager = PortableServer_POA__get_the_POAManager(self->ob,
		  &(self->ev));
		checkCORBA(self->ev);
		/* XXX check exception */
		if (the_manager == CORBA_OBJECT_NIL) {
			Py_INCREF(Py_None);
			return Py_None;
		}
		return (PyObject *) POAManager2Object(the_manager);
	}
	return Py_FindMethod(POA_methods, (PyObject *)self, name);
}

static int
POA_setattr(self, name, v)
	POAObject *self;
	char *name;
	PyObject *v;
{
	return -1;
}

statichere PyTypeObject POA_Type = {
	/* The ob_type field must be initialized in the module init function
	 * to be portable to Windows without using C++. */
	PyObject_HEAD_INIT(NULL)
	0,			/*ob_size*/
	"PortableServer.POA",			/*tp_name*/
	sizeof(POAObject),	/*tp_basicsize*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)POA_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)POA_getattr, /*tp_getattr*/
	(setattrfunc)POA_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

/* End POA */

static PyObject *
RootPOA (
	PyObject *self,
	PyObject *arg
) {
	ORBObject *orb;
	PortableServer_POA poa;

	if (PyArg_ParseTuple(arg, "O", &orb) == -1)
		return NULL;
/*	if (!ORBObject_Check(orb))
		return NULL;*/
	poa = (PortableServer_POA) CORBA_ORB_resolve_initial_references(orb->ob,
	     "RootPOA", &(orb->ev));
	checkCORBA(orb->ev);
	if (poa == CORBA_OBJECT_NIL) {
	  fprintf(stderr, "POA is NULL\n");
	  Py_INCREF(Py_None);
	  return Py_None;
	}
	return (PyObject *) POA2Object(poa);
}

static PyMethodDef PortableServer_methods[] = {
	{"RootPOA",		RootPOA,	1},
	{NULL,		NULL}		/* sentinel */
};


#ifndef DL_EXPORT
#define DL_EXPORT(x) x
#endif

DL_EXPORT(void)
initPortableServer()
{
	PyObject *m, *d, *CORBAmodule;

	/* Initialize the type of the new type object here; doing it here
	 * is required for portability to Windows without requiring C++. */
	POA_Type.ob_type = &PyType_Type;
	POAManager_Type.ob_type = &PyType_Type;

	/* Create the module and add the functions */
	m = Py_InitModule("PortableServer", PortableServer_methods);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyErr_NewException("PortableServer.error", NULL, NULL);
	PyDict_SetItemString(d, "error", ErrorObject);

	CORBAmodule = PyImport_ImportModule("CORBA");
	if (CORBAmodule != NULL) {
		d = PyModule_GetDict(CORBAmodule);
		Object_cast = PyDict_GetItemString(d, "Object_cast");
	} else {
		fprintf(stderr, "could not import CORBA\n");
	}
}
