#include "global.h"

/*
 * Button
 */
static VALUE
button_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_button_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_button_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
button_pressed(self)
    VALUE self;
{
    gtk_button_pressed(GTK_BUTTON(get_widget(self)));
    return self;
}

static VALUE
button_released(self)
    VALUE self;
{
    gtk_button_released(GTK_BUTTON(get_widget(self)));
    return self;
}

static VALUE
button_clicked(self)
    VALUE self;
{
    gtk_button_clicked(GTK_BUTTON(get_widget(self)));
    return self;
}

static VALUE
button_enter(self)
    VALUE self;
{
    gtk_button_enter(GTK_BUTTON(get_widget(self)));
    return self;
}

static VALUE
button_leave(self)
    VALUE self;
{
    gtk_button_leave(GTK_BUTTON(get_widget(self)));
    return self;
}

static VALUE
button_set_relief(self, style)
    VALUE self, style;
{
    gtk_button_set_relief(GTK_BUTTON(get_widget(self)), FIX2INT(style));
    return self;
}

static VALUE
button_get_relief(self)
    VALUE self;
{
    GtkReliefStyle style;
    style = gtk_button_get_relief(GTK_BUTTON(get_widget(self)));
    return INT2FIX(style);
}

void Init_gtk_button()
{
    gButton = rb_define_class_under(mGtk, "Button", gBin);

    rb_define_const(gButton, "SIGNAL_PRESSED", rb_str_new2("pressed"));
    rb_define_const(gButton, "SIGNAL_RELEASED", rb_str_new2("released"));
    rb_define_const(gButton, "SIGNAL_CLICKED", rb_str_new2("clicked"));
    rb_define_const(gButton, "SIGNAL_ENTER", rb_str_new2("enter"));
    rb_define_const(gButton, "SIGNAL_LEAVE", rb_str_new2("leave"));

    rb_define_method(gButton, "initialize", button_initialize, -1);
    rb_define_method(gButton, "pressed", button_pressed, 0);
    rb_define_method(gButton, "released", button_released, 0);
    rb_define_method(gButton, "clicked", button_clicked, 0);
    rb_define_method(gButton, "enter", button_enter, 0);
    rb_define_method(gButton, "leave", button_leave, 0);
    rb_define_method(gButton, "set_relief", button_set_relief, 1);
    rb_define_method(gButton, "get_relief", button_get_relief, 0);
}


/*
 * ToggleButton
 */
static VALUE
tbtn_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_toggle_button_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_toggle_button_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
tbtn_set_mode(self, mode)
    VALUE self, mode;
{
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(get_widget(self)),
			       NUM2INT(mode));
    return self;
}

static VALUE
tbtn_set_state(self, state)
    VALUE self, state;
{
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(get_widget(self)),
				RTEST(state));
    return self;
}

static VALUE
tbtn_toggled(self)
    VALUE self;
{
    gtk_toggle_button_toggled(GTK_TOGGLE_BUTTON(get_widget(self)));
    return self;
}

static VALUE
tbtn_is_active(self)
    VALUE self;
{
    if (GTK_TOGGLE_BUTTON(get_widget(self))->active)
	return Qtrue;
    return Qfalse;
}
static VALUE
tbtn_set_active(self,n)
    VALUE self, n;
{
    (void)gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(get_widget(self)),
				       RTEST(n));
    return self;
}

void Init_gtk_toggle_button()
{
    gTButton = rb_define_class_under(mGtk, "ToggleButton", gButton);

    rb_define_const(gTButton, "SIGNAL_TOGGLED", rb_str_new2("toggled"));

    rb_define_method(gTButton, "initialize", tbtn_initialize, -1);
    rb_define_method(gTButton, "set_mode", tbtn_set_mode, 1);
    rb_define_method(gTButton, "set_state", tbtn_set_state, 1); /* back-compat. */
    rb_define_method(gTButton, "toggled", tbtn_toggled, 0);
    rb_define_method(gTButton, "active", tbtn_is_active, 0);
    rb_define_method(gTButton, "active?", tbtn_is_active, 0);
    rb_define_method(gTButton, "set_active", tbtn_set_active, 1);
    rb_define_method(gTButton, "active=", tbtn_set_active, 1);
}


/*
 * CheckButton
 */
static VALUE
cbtn_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_check_button_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_check_button_new();
    }

    set_widget(self, widget);
    return Qnil;
}

void Init_gtk_check_button()
{
    gCButton = rb_define_class_under(mGtk, "CheckButton", gTButton);

    rb_define_method(gCButton, "initialize", cbtn_initialize, -1);
}


/*
 * RadioButton
 */
static VALUE
rbtn_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE arg1, arg2;
    GtkWidget *widget;
    GSList *list = NULL;
    char *label = NULL;
    
    if (rb_scan_args(argc, argv, "02", &arg1, &arg2) == 1 &&
	TYPE(arg1) == T_STRING) {
	label = RSTRING(arg1)->ptr;
    }
    else {
	if (!NIL_P(arg2)) {
	    label = STR2CSTR(arg2);
	}
	if (rb_obj_is_kind_of(arg1, gRButton)) {
	    GtkWidget *b = get_widget(arg1);
	    list = GTK_RADIO_BUTTON(b)->group;
	}
	else {
	    list = ary2gslist(arg1);
	}
    }
    if (label) {
	widget = gtk_radio_button_new_with_label(list, label);
    }
    else {
	widget = gtk_radio_button_new(list);
    }
    set_widget(self, widget);
    return Qnil;
}

static VALUE
rbtn_group(self)
    VALUE self;
{
    GtkWidget *widget = get_widget(self);
    
    return gslist2ary(gtk_radio_button_group(GTK_RADIO_BUTTON(widget)));
}

void Init_gtk_radio_button()
{
    gRButton = rb_define_class_under(mGtk, "RadioButton", gCButton);

    rb_define_method(gRButton, "initialize", rbtn_initialize, -1);
    rb_define_method(gRButton, "group", rbtn_group, 0);
}
