#include "global.h"

/*
 * Gdk::Colormap
 */

VALUE gdkColormap;

static VALUE
gdkcmap_s_get_system(self)
    VALUE self;
{
    GdkColormap *cmap;
    cmap = gdk_colormap_get_system();
    return make_gdkcmap(cmap);
}
 
/* obsoleted */
static VALUE
gdkcmap_alloc(self, color)
    VALUE self, color;
{
    gboolean result;
    rb_warn("Gdk::Colormap.alloc is obsoleted. use Gdk::Colormap.alloc_color.");
    result = gdk_color_alloc(get_gdkcmap(self), get_gdkcolor(color));
    return result?Qtrue:Qfalse;
}

static VALUE
gdkcmap_alloc_color(self, color, writeable, best_match)
    VALUE self, color, writeable, best_match;
{
    gboolean result;
    result = gdk_colormap_alloc_color(get_gdkcmap(self), get_gdkcolor(color),
				      RTEST(writeable), RTEST(best_match));
    return result?Qtrue:Qfalse;
}


/*
 * Gdk::Color
 */

VALUE gdkColor;

static VALUE
gdkcolor_s_new(self, r, g, b)
    VALUE self;
    VALUE r, g, b;
{
    GdkColor c;
    c.pixel = 0; /* INT2FIX(p); */
    c.red = INT2FIX(r);
    c.green = INT2FIX(g);
    c.blue = INT2FIX(b);
    return make_gdkcolor(&c);
}


/*
 * Gdk::ColorContext
 */
VALUE gdkColorContext;

/*
 * Gdk::Visual
 */

VALUE gdkVisual;


void
Init_gtk_gdk_color()
{
    /*
     * Gdk::Colormap
     */
    gdkColormap = rb_define_class_under(mGdk, "Colormap", rb_cData);

    rb_define_singleton_method(gdkColormap, "get_system",
			       gdkcmap_s_get_system, 0);
    rb_define_method(gdkColormap, "alloc", gdkcmap_alloc, 1);
    rb_define_method(gdkColormap, "alloc_color", gdkcmap_alloc_color, 3);

    /*
     * Gdk::Color
     */
    gdkColor = rb_define_class_under(mGdk, "Color", rb_cData);

    rb_define_singleton_method(gdkColor, "new", gdkcolor_s_new, 3);

    /*
     * Gdk::ColorContext
     */
    gdkColorContext = rb_define_class_under(mGdk, "ColorContext", rb_cData);

    /*
     * Gdk::Visual
     */
    gdkVisual = rb_define_class_under(mGdk, "Visual", rb_cData);
}
