// fbc.h
//
//  Forth Byte Codes (FBC)
//
//  Copyright (c) 1996--1999 Krishna Myneni, Creative Consulting for
//    Research & Education
//  Created: 2-24-96
//  Last Revised: 6-10-1999

#ifndef __FORTHBYTECODES_H__
#define __FORTHBYTECODES_H__

#define OP_FALSE     0
#define OP_TRUE      1

#define OP_CR       30
#define OP_QUOTE    34
#define OP_EMIT     'e'
#define OP_SPACES   ' '
#define OP_COUNT    'c'
#define OP_TYPE     't'


#define OP_WORDS    'w'
#define OP_ALLOT    'a'

#define OP_BASE     'B'
#define OP_BINARY   'b'
#define OP_DECIMAL  'd'
#define OP_HEX      'h'

#define OP_CHAR     'p'
#define OP_I        'i'
#define OP_J        'j'

#define OP_KEY      'K'
#define OP_ACCEPT   'T'

#define OP_FVAL     'F'
#define OP_IVAL     'I'
#define OP_ADDR     'A'
#define OP_CALL     'C'
#define OP_DEFINITION 'D'

#define OP_FETCH    '@'
#define OP_STORE    '!'

#define OP_DOT      '.'
#define OP_UDOT     'u'
#define OP_FDOT     'f'
#define OP_DOTQUOTE 's'
#define OP_DOTS     'S'

#define OP_NUMBERQUERY 'N'

// arithmetic operators

#define OP_ADD      '+'
#define OP_SUB      '-'
#define OP_MUL      '*'
#define OP_DIV      '/'
#define OP_MOD      '%'
#define OP_SLASHMOD 'M'
#define OP_STARSLASH 'X'
#define OP_STARSLASHMOD 'Y'

// bitwise logic and shift operators

#define OP_AND      '&'
#define OP_OR       '|'
#define OP_XOR      '^'
#define OP_NOT      '~'
#define OP_LSHIFT   'L'
#define OP_RSHIFT   'R'

// file access functions

#define OP_OPEN     10
#define OP_LSEEK    11
#define OP_CLOSE    12
#define OP_READ     13
#define OP_WRITE    14
#define OP_IOCTL    15
#define OP_USLEEP   16

// memory

#define OP_FILL     20
#define OP_CMOVE    21
#define OP_CMOVEFROM 22

// floating point functions

#define OP_FSIN     128
#define OP_FCOS     129
#define OP_FTAN     130
#define OP_FASIN    131
#define OP_FACOS    132
#define OP_FATAN    133
#define OP_FEXP     134
#define OP_FLN      135
#define OP_FLOG     136
#define OP_FATAN2   137

#define OP_FMIN     140
#define OP_FMAX     141
#define OP_FLOOR    142
#define OP_FROUND   143

#define OP_STOF     150
#define OP_FTOS     151
#define OP_DEGTORAD 152
#define OP_RADTODEG 153

// increment, decrement, and other integer numeric operators

#define OP_INC      160
#define OP_DEC      161
#define OP_ABS      162
#define OP_NEG      163
#define OP_MIN      164
#define OP_MAX      165
#define OP_TWOSTAR  166
#define OP_TWODIV   167
#define OP_TWOPLUS  168
#define OP_TWOMINUS 169

// more stack to memory

#define OP_CFETCH   170
#define OP_CSTORE   171
#define OP_WFETCH   172
#define OP_WSTORE   173
#define OP_DFFETCH  174
#define OP_DFSTORE  175
#define OP_SFFETCH  176
#define OP_SFSTORE  177
#define OP_SPFETCH  178
#define OP_PLUSSTORE 179

// floating pt arithmetic

#define OP_FADD     180
#define OP_FSUB     181
#define OP_FMUL     182
#define OP_FDIV     183
#define OP_FABS     184
#define OP_FNEG     185
#define OP_FPOW     186
#define OP_FSQRT    187

// floating pt relational

#define OP_FEQ      190
#define OP_FNE      191
#define OP_FLT      192
#define OP_FGT      193
#define OP_FLE      194
#define OP_FGE      195

// stack operators

#define OP_DROP     200
#define OP_DUP      201
#define OP_SWAP     202
#define OP_OVER     203
#define OP_ROT      204
#define OP_MINUSROT 205
#define OP_NIP      206
#define OP_TUCK     207
#define OP_PICK     208
#define OP_ROLL     209

#define OP_2DROP    210
#define OP_2DUP     211
#define OP_2SWAP    212
#define OP_2OVER    213
#define OP_2ROT     214
#define OP_DEPTH    215
#define OP_QUERYDUP 216

// return stack operators

#define OP_PUSH     220
#define OP_POP      221
#define OP_PUSHIP   222
#define OP_RFETCH   223
#define OP_RPFETCH  224

// address fetch operator

#define OP_AFETCH   225

// branch and flow control

#define OP_JZ       230
#define OP_JNZ      231
#define OP_JMP      232
#define OP_LOOP     233
#define OP_PLUSLOOP 234
#define OP_UNLOOP   235
#define OP_EXECUTE  236

#define OP_RET      238
#define OP_ABORT    239
#define OP_QUIT     240

// relational operators

#define OP_EQ       '='		
#define OP_NE       244
#define OP_LT       '<'		
#define OP_GT       '>'	
#define OP_LE       243
#define OP_GE       242

#define OP_ZEROLT   245
#define OP_ZEROEQ   246
#define OP_ZEROGT   247

#define OP_ULT      248

#endif


