// ---------------------------------------------------------------------------
// - Meta.hpp                                                                -
// - aleph engine - meta class definition                                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_META_HPP
#define  ALEPH_META_HPP

#ifndef  ALEPH_VECTOR_HPP
#include "Vector.hpp"
#endif

namespace aleph {

  /// The Meta class is a wrapper class for c++ class. The class holds 
  /// a pointer to a static member function which creates the object. The
  /// apply method is used to create an instance wrapped by this object.
  /// @author amaury darsch

  class Meta : public Object {
  public:
    /// the standard function prototype
    typedef Object* (*t_meta) (Vector*);

  private:
    /// the function to call during new
    t_meta p_func;

  public:
    /// create an empty meta class
    Meta (void);

    /// create a new meta class with a constructor function
    /// @param func the function to store
    Meta (t_meta func);

    /// @return the class name
    String repr (void) const;

    /// return a new meta object 
    /// @param interp the current interpreter
    /// @param nset   the current nameset
    /// @param args   the arguments to apply
    Object* apply (Interp* interp, Nameset* nset, Cons* args);

  private:
    // make the copy constructor private
    Meta (const Meta&);
    // make the assignment operator private
    Meta& operator = (const Meta&);  
  };
}

#endif
