// rfile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _RFILE_H_
#define _RFILE_H_

#include <fstream.h>
#include "rdefs.h"

#define LOG_TYPE_UNKNOWN       0
#define LOG_TYPE_CT7           1
#define LOG_TYPE_CT8           2
#define LOG_TYPE_CT9           3
#define LOG_TYPE_TRLOG         4
#define LOG_TYPE_DBASE         5
#define LOG_TYPE_NALOG         6
#define LOG_TYPE_WRTC          7
#define LOG_TYPE_DXINFO        8
#define LOG_TYPE_SDF           9
#define LOG_TYPE_NA9LOG        10
#define LOG_TYPE_DXCLUS        11
#define LOG_TYPE_ADIF          12
#define LOG_TYPE_ARRL          13

class RFile {
    fstream     fp2;
#if !defined(LINUX)
    boolean     eof2;
#endif
    char        *fileName;

public:
    RFile();
    RFile(char *name);
    virtual ~RFile();
#ifdef LINUX
    boolean open(char *name, int mode = ios::in | ios::out);
#else
    boolean open(char *name, int mode = ios::in | ios::out | ios::binary);
#endif
    boolean eof();
    virtual boolean close()             { fp2.close(); return TRUE; }
    boolean isOpen()            { return (fileName != NULL); };
    char *name()                { return fileName; };
    int fileType();
    void position(long pos)   { fp2.seekg(pos); };
//    boolean position(long);
    boolean read(void *, int);
    boolean write(void *, int);
    boolean getString(char *, int);
    long size();
    char *suffix();
};

#endif
