// qsodata.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _QSOFILE_H_
#define _QSOFILE_H_

#include "rfile.h"
#include "qsodata.h"

#define TIME_DEFAULT         0           // Time stored as 'C' type.
#define TIME_APPROACH        1           // "TM9" appended to time's field name.  Used by Approach.

#define BAND_DEFAULT         0           // Band field in ADIF compatible format.
#define BAND_METERS          1           // Band field in meters, field type 'N'.
#define BAND_MHZ             2           // band field in MHz, field type 'N'. No fractions!

#define FIELD_QSONUM         1
#define FIELD_FREQ           2

#define NOTE_SIZE            40

class RQsoFile : public RFile {
    
protected:
    header_data header;
    unsigned long location;               // 0 - header, 1+ QSO records
    boolean headerWritten;
    
    struct fileoptions_struct {
        unsigned char time;
        unsigned char band;
        unsigned char fields;
        unsigned char contest;
        char szNote[NOTE_SIZE];
    } fileOptions;
    
public:
    RQsoFile();
    virtual boolean open(char *, int) = 0;
    
//    void storeHeader(header_data oh)  {memcpy(&header, &oh, sizeof(header_data));};
    void storeHeader(header_data oh)  {header = oh;};
    header_data& headerInfo()          {return header;};
    virtual boolean writeHeader(header_data) = 0;

    virtual boolean setOptions(char *);
    
    virtual boolean nextQso(qso_data *) = 0;
    virtual boolean writeQso(qso_data *) = 0;
    long position()             { return location; };
};

#endif
