// ct9file.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _CT9FILE_H_
#define _CT9FILE_H_

#include "qsofile.h"

#define CT9_CALL_SIZE           32
#define CT9_NAME_SIZE           32
#define CT9_ADDRESS_SIZE        64
#define CT9_TOWN_SIZE           32
#define CT9_STATE_SIZE          8
#define CT9_ZIP_SIZE            16
#define CT9_ZONE_SIZE           8
#define CT9_GRID_SIZE           8
#define CT9_CLUB_SIZE           64
#define CT9_CHECK_SIZE          4
#define CT9_SECTION_SIZE        8


// this is the binary file format for CT version 9
// the first 1024 bytes are the header (struct restart_header)
// the remainder of the file is in 50 byte rcords  (struct loag_data)

class RCt9File : public RQsoFile {
    
typedef struct restart_header       // info in front of log data in .BIN file 
{
   char     contest_title[32];
   char     version_str[12];
   short    category_int;
   short    tx_pwr;
   char     call[32];
   char     name[32];
   char     address[64];
   char     town[32];
   char     state[8];
   char     data[32];
   struct   comm_data      // comm port setup info 
   {
      char  device;
      char  baud;          // 0 = 1200, 1 = 2400, 2 = 4800, 3 = 9600, 4 = 19.2
   } comm[4];
   uchar    contest;
   uchar    mode;
   uchar    category;
   uchar    tnc;
   uchar    cw_port;
   uchar    dvk_port;
   uchar    station;
   uchar    radio;
   struct   
   {
      uchar no_work_dupe;
      uchar m_stn;
      uchar post;
      uchar beep;
      uchar band_rate;
      uchar sound;
      uchar correct;
      uchar cw_abbrev;
      uchar autosave;
      uchar nocompress;
      uchar see_warc;
      uchar print;
      uchar rpt;
      uchar kw_right;
      uchar qsl;
      uchar bandspot;
      uchar spare[14];
   } flags;
   char     cq_msg[64];
   char     qrz_msg[64];
   char     ex_msg[64];
   char     zip[16];
   char     zone[8];
   char     F6_text[64];
   char     F7_text[64];
   char     club[64];
   struct   ss_stuff
   {
      char  prec[4];
      char  chk[4];
   } ss;

   struct   fd_stuff
   {
      uchar    ep_bonus       ;
      uchar    pr_bonus       ;
      uchar    loc_bonus      ;
      uchar    info_bonus     ;
      uchar    msg_bonus      ;
      uchar    sat_bonus      ;
      uchar    nat_bonus      ;
      uchar    w1aw_bonus     ;
      uchar    pkt_bonus      ;
      uchar    power          ;
      uchar    tx_count       ;
      char     category       ;
      uchar    tfc_bonus      ;
      uchar     vhf_bonus;
      uchar    spare[2]       ;
   } fd;
   char     my_grid[8];
   char     sec[8];
   char     dupe_msg[32];
   struct   dvp_stuff
   {
      uchar ingain;
      uchar outgain;
      uchar onair;
      uchar mon;
      char  ram_disk;
      uchar ptt;
      uchar backcopy;
      uchar spare;
      ushort clipping_pt;
      ushort rpt_delay;
      long  auto_space;
      uchar     disable_send_ser;
      uchar     disable_send_call;
      char  dvp_spare[14];
   } dvp;
   char     last_op[16];
   short    off_thresh;
   char     cont;
   
   char     cw_speed;
   short    gap_time;
   unsigned char comport_count;
   unsigned char pad;
   char     lat[10];
   char     lon[10];
   unsigned char radio2;
   unsigned char poll_rate;
   unsigned char rotor1;
   unsigned char rotor2;
   short    rotoroffset;
   short    rotor2offset;
   char     utc_flag;
   char     spare[165];
   
//   char     spare[199];
} Ct9Header;

Ct9Header ct9header;

public:

typedef struct log_data_struct  // binary records kept in .BIN file 
{
   char     call[16];         // callsign of station worked 
   char     info[8];          // received info: zone, power, grid, sec, etc
   uchar    band;             // 1 = 160, 2 = 80 ... 6 =  10 
   uchar    mode;             // 0 = CW, 1 = SSB, 2 = RTTY
   uchar    status;           // split or transceive, which VFO active 
   uchar    stn_num;          // tag identifying computer this logged on
// Careful!  Many CT files appear to have the SS serial number in rst instead!
   union {
      short    rst;              // received RST, sent is always 59 or 599 
      short    serial;           // received serial number in SS
   };
   short serial_sent;        // Serial number sent, mostly for SS
   struct   fd_info 
   {
      uchar    tx_count;      // Tx count
      uchar    category;
   } fd;
   ulong    freq[2];          // frequency read from VFO A and B 
   long     time;             // UNIX time: seconds since Jan 1, 1970 
   union {
   uchar    novice;           // novice in 10 mtr test
   uchar    check;            // check in SS
   short    tx_pwr;           // for ARRL DX test outside W/VE
   short    qtc_num;};       // number of qtc record this sent to (WAE)
   uchar    qsl_sent;         // qsl sent flag
   char     filler;          // log_data_struct not 50 bytes,  make it so.
} ct9_log_data;

    RCt9File()                   {location = 0;};
    RCt9File(char *name);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
//    ct9_log_data nextCTQso();                    /* Return next CT QSO record */
    virtual boolean nextQso(qso_data *);         /* Return next generic QSO record */
    virtual boolean writeQso(qso_data *);        /* Write a generic QSO record */
    virtual boolean writeHeader(header_data);
};

#endif
