/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogGaussianHill.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "GuiDialogOAC.h"
#include "MathTrig.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogGaussianHill::TFDialogGaussianHill (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Gaussian Hill Dialog", 
					"Parameters", 6, 5),
		  d_vbList (TRUE, 0),
		  d_hbCX (TRUE, 5),
		  d_hbCY (TRUE, 5),
		  d_hbRadius (TRUE, 5),
		  d_hbScaleFactor (TRUE, 5),
		  d_hbRadFac (TRUE, 5),
		  d_hbSmoothFactor (TRUE, 5),
		  d_hbDeltaScale (TRUE, 5),
		  d_frmOptions (_("Gaussian Hill Options"))
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogGaussianHill\n");

	p_lblCX = new Gtk_Label (_("Center X"));
	p_lblCY = new Gtk_Label (_("Center Y"));
	p_lblRadius = new Gtk_Label (_("Hill Radius"));
	p_lblScaleFactor = new Gtk_Label (_("Scale Factor"));
	p_lblRadFac = new Gtk_Label (_("Radius Factor"));
	p_lblSmoothFactor = new Gtk_Label (_("Smoothing Factor"));
	p_lblDeltaScale = new Gtk_Label (_("Delta Scale Factor"));

	p_adjCX = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjCY = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjRadius = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjScaleFactor = new Gtk_Adjustment (1.5, 1, 2, 0.01);
	p_adjRadFac = new Gtk_Adjustment (0.33, 0, 1, 0.01);
	p_adjSmoothFactor = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjDeltaScale = new Gtk_Adjustment (0.1, 0, 0.5, 0.01);

	p_hsCX = new Gtk_HScale (*p_adjCX);
	p_hsCY = new Gtk_HScale (*p_adjCY);
	p_hsRadius = new Gtk_HScale (*p_adjRadius);
	p_hsScaleFactor = new Gtk_HScale (*p_adjScaleFactor);
	p_hsRadFac = new Gtk_HScale (*p_adjRadFac);
	p_hsSmoothFactor = new Gtk_HScale (*p_adjSmoothFactor);
	p_hsDeltaScale = new Gtk_HScale (*p_adjDeltaScale);

	buildDialogWindow ();
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Gaussian Hill: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (p_adjCX->value_changed, this, &TFDialogGaussianHill::updatePreviewCallback);
	connect_to_method (p_adjCY->value_changed, this, &TFDialogGaussianHill::updatePreviewCallback);
	connect_to_method (p_adjRadius->value_changed, this, &TFDialogGaussianHill::updatePreviewCallback);
	connect_to_method (p_adjScaleFactor->value_changed, this, &TFDialogGaussianHill::updatePreviewCallback);
	connect_to_method (p_adjRadFac->value_changed, this, &TFDialogGaussianHill::updatePreviewCallback);
	connect_to_method (p_adjSmoothFactor->value_changed, this, &TFDialogGaussianHill::updatePreviewCallback);
	connect_to_method (p_adjDeltaScale->value_changed, this, &TFDialogGaussianHill::updatePreviewCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogGaussianHill::~TFDialogGaussianHill ()
{
	delete p_lblCX;
	delete p_lblCY;
	delete p_lblRadius;
	delete p_lblScaleFactor;
	delete p_lblRadFac;
	delete p_lblSmoothFactor;
	delete p_lblDeltaScale;

	delete p_adjCX;
	delete p_adjCY;
	delete p_adjRadius;
	delete p_adjScaleFactor;
	delete p_adjRadFac;
	delete p_adjSmoothFactor;
	delete p_adjDeltaScale;

	delete p_hsCX;
	delete p_hsCY;
	delete p_hsRadius;
	delete p_hsScaleFactor;
	delete p_hsRadFac;
	delete p_hsSmoothFactor;
	delete p_hsDeltaScale;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogGaussianHill\n");
}


/*
 *  insertOptions: fill the dialog's VBox
 */
void TFDialogGaussianHill::insertOptions ()
{
	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	d_hbCX.pack_start (*p_lblCX, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblCX->show ();
	p_hsCX->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsCX->set_digits (2);
	p_hsCX->set_draw_value (TRUE);
	d_hbCX.pack_end (*p_hsCX, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsCX->show ();
	d_vbList.pack_start (d_hbCX, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbCX.show ();

	d_hbCY.pack_start (*p_lblCY, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblCY->show ();
	p_hsCY->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsCY->set_digits (2);
	p_hsCY->set_draw_value (TRUE);
	d_hbCY.pack_end (*p_hsCY, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsCY->show ();
	d_vbList.pack_start (d_hbCY, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbCY.show ();

	d_hbRadius.pack_start (*p_lblRadius, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblRadius->show ();
	p_hsRadius->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsRadius->set_digits (2);
	p_hsRadius->set_draw_value (TRUE);
	d_hbRadius.pack_end (*p_hsRadius, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsRadius->show ();
	d_vbList.pack_start (d_hbRadius, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbRadius.show ();

	d_vbList.pack_start (d_hSep);
	d_hSep.show ();

	d_hbScaleFactor.pack_start (*p_lblScaleFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblScaleFactor->show ();
	p_hsScaleFactor->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsScaleFactor->set_digits (2);
	p_hsScaleFactor->set_draw_value (TRUE);
	d_hbScaleFactor.pack_end (*p_hsScaleFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsScaleFactor->show ();
	d_vbList.pack_start (d_hbScaleFactor, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbScaleFactor.show ();

	d_hbRadFac.pack_start (*p_lblRadFac, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblRadFac->show ();
	p_hsRadFac->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsRadFac->set_digits (2);
	p_hsRadFac->set_draw_value (TRUE);
	d_hbRadFac.pack_end (*p_hsRadFac, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsRadFac->show ();
	d_vbList.pack_start (d_hbRadFac, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbRadFac.show ();

	d_hbSmoothFactor.pack_start (*p_lblSmoothFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblSmoothFactor->show ();
	p_hsSmoothFactor->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsSmoothFactor->set_digits (2);
	p_hsSmoothFactor->set_draw_value (TRUE);
	d_hbSmoothFactor.pack_end (*p_hsSmoothFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsSmoothFactor->show ();
	d_vbList.pack_start (d_hbSmoothFactor, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbSmoothFactor.show ();

	d_hbDeltaScale.pack_start (*p_lblDeltaScale, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblDeltaScale->show ();
	p_hsDeltaScale->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsDeltaScale->set_digits (2);
	p_hsDeltaScale->set_draw_value (TRUE);
	d_hbDeltaScale.pack_end (*p_hsDeltaScale, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsDeltaScale->show ();
	d_vbList.pack_start (d_hbDeltaScale, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbDeltaScale.show ();

	d_frmOptions.add (d_vbList);
	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 4);
        d_vbList.show ();
	d_frmOptions.show ();
        this->p_frmBase->show ();
        this->get_vbox()->show ();
}



void TFDialogGaussianHill::buildDialogWindow ()
{
	this->set_usize (450, 350);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions ();
	this->fillActionArea ();

	connect_to_method (p_drawArea->button_press_event, this, 
			&TFDialogGaussianHill::daButtonPressedCallback);
	
	this->show ();
}


/*
 *  buttonCallbackApply: process Apply button
 */
void TFDialogGaussianHill::buttonCallbackApply ()
{
	float		cx, cy, sf, radfac, radius, smooth, deltascale; 

	cx = p_adjCX->get_value ();
	cy = p_adjCY->get_value ();
	radius= p_adjRadius->get_value (); 
        sf = p_adjScaleFactor->get_value ();
	radfac = p_adjRadFac->get_value (); 
	smooth = p_adjSmoothFactor->get_value ();
	deltascale = p_adjDeltaScale->get_value ();

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogGaussianHill::buttonCallbackApply");
	p_HFO->gaussianHill (cx, cy, radius, radfac, sf, smooth, deltascale);
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}

	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a slider has been updated.
 */
void TFDialogGaussianHill::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	float		cx, cy, radius, sf, radfac, smooth, deltascale; 

	cx = p_adjCX->get_value ();
	cy = p_adjCY->get_value ();
	radius= p_adjRadius->get_value (); 
        sf = p_adjScaleFactor->get_value ();
        radfac = p_adjRadFac->get_value (); 
	smooth = p_adjSmoothFactor->get_value ();
	deltascale = p_adjDeltaScale->get_value ();

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogGaussianHill::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogGaussianHill::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFOPreview==NULL", "TFDialogGaussianHill::updatePreviewCallback");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	p_HFOPreview->gaussianHill (cx, cy, radius, radfac, sf, smooth, deltascale);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
	d_cx = (int)(cx*(float)p_drawArea->width()); 
	d_cy = (int)(cy*(float)p_drawArea->height()); 
	this->drawCrosshairs (d_cx, d_cy);
}


/*
 *  daButtonPressedCallback: update the preview p_drawArea and adjustment 
 * 	the appropriate widgets (done when the user clicks on the preview)
 */
int TFDialogGaussianHill::daButtonPressedCallback (GdkEventButton *e)
{
	if (!d_cbUsePreview.get_active())
		return 1;

	int	w = this->p_drawArea->width(),
		h = this->p_drawArea->height();

	if (e->button == 1)
		{
		p_adjCX->set_value (e->x/w);
		p_adjCY->set_value (e->y/h);
		}
	else
	if (e->button == 2)
		{
		float	d = MathTrig::distance (p_adjCX->get_value()*w, 
				p_adjCY->get_value()*h, e->x, e->y);

		d/=((p_drawArea->width()+p_drawArea->height())/2);
		if (d > 1)
			d=1;
		p_adjRadius->set_value (d); 
		}
	updatePreviewCallback ();
	return 0;
}

