/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GUI_DIALOG_OAC_H
#define _GUI_DIALOG_OAC_H


#include <gtk--.h>
#include <gtk/gtk.h>
#include "GlobalDefs.h"


/*
 *  GuiDialogOAC: create a basic dialog dialog with 3 buttons 
 */
class GuiDialogOAC : public Gtk_Dialog
	{
	public: 
					GuiDialogOAC (char *windowTitle=NULL, char *frameTitle=NULL);
					~GuiDialogOAC (); 
		virtual void		buildDialogWindow ();

		static const int	s_HBOff,	// default H&V Box
					s_VBOff;	// offsets 

	protected: 	
		void			setupVBox ();
		void			fillActionArea ();
		virtual void 		fillVBox ();
		virtual void 		buttonCallbackOK ();
		virtual void 		buttonCallbackApply ();
		virtual void 		buttonCallbackCancel ();
		virtual gint		delete_event_impl (GdkEventAny *e);


		Gtk_Button			d_btnOK, 
						d_btnApply, 
						d_btnCancel;
  		Gtk_Frame			*p_frmBase;
		char				*p_windowTitle,
						*p_frameTitle;
		bool				b_applyHit;
	};


#endif // _GUI_DIALOG_OAC_H

