# Sketch - A Python-based interactive drawing program
# Copyright (C) 1997, 1998, 1999 by Bernhard Herzog
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307	USA

#
# main module
#
# Provides the main() function which reads the user specific
# configuration, creates the application object and enters the
# application's mainloop.
#
# This module also has some global variables:
#
# application
#
#	The application object. This is None until the application
#	object has been created.
#
#	XXX this variable should be in Sketch.__init__
#
#

import sys, getopt, string

import Sketch
from Sketch.Lib import util


usage = '''\
Usage:	sketch [Options] [filename]

sketch accepts these options:

  -h --help		Print this help message
  -d --display=DISPLAY	Use DISPLAY a X Display
  -g --geometry=WxH+X+Y	The geometry of the main window in standard X fashion
  --version		Print the version number to stdout

for compatibility with other X software sketch also accepts geometry
specifications in the standard X format:

  -geometry WxH+X+Y

'''

version = '''\
Sketch %s
Copyright (C) 1998 Bernhard Herzog
Sketch comes with ABSOLUTELY NO WARRANTY.
You may redistribute copies of Sketch
under the terms of the GNU Library General Public License.
For more information about these matters, see the files named COPYING.'''

def process_args(args):
    # Read options from the command line. Return an instance object with the
    # instance variables:
    #	display		name of the X-display or None
    #	geometry	geometry of the main window or None
    #	args		rest of the arguments after the last option
    #
    # To behave more like other X-programs, sketch should accept the options
    # -display and -geometry with a single hyphen and no `='...

    # recognize a standard X geometry specification... (hack)
    if '-geometry' in args:
	try:
	    idx = args.index('-geometry')
	    geo = args[idx:idx + 2]
	    if len(geo) == 2:
		del args[idx:idx + 2]
		geo[0] = '-g'
		args[0:0] = geo
	except:
	    pass

    opts, args = getopt.getopt(args, 'd:g:hi',
			       ['display=', 'geometry=', 'help', 'version'])
    # the option -i is a hack to allow sketch to be used as a `python
    # interpreter' in the python shell in python-mode.el

    options = util.Empty(args = args,
			 display = None,
			 geometry = None)

    for optchar, value in opts:
	if optchar == '-d' or optchar == '--display':
	    options.display = value
	elif optchar == '-g' or optchar == '--geometry':
	    options.geometry = value
	elif optchar == '-h' or optchar == '--help':
	    print usage
	    sys.exit(0)
	elif optchar == '--version':
	    print version % Sketch.SketchVersion
	    sys.exit(0)

    return options


#
#	Global Variables
#

application = None

#
#
#

def main():
    global application

    try:
	options = process_args(sys.argv[1:])
    except getopt.error:
	sys.stderr.write(usage)
	sys.exit(1)

    if options.args:
	filename = options.args[0]
    else:
	filename = ''

    # workaround for a threaded _tkinter in Python 1.5.2
    if sys.version[:5] == '1.5.2':
        #print '_tkinter', sys.modules.get('_tkinter')
        import paxtkinter
        sys.modules['_tkinter'] = paxtkinter
        #print '_tkinter', sys.modules.get('_tkinter')
    
    Sketch.config.load_user_preferences()

    from Sketch.UI.skapp import SketchApplication

    Sketch.Issue(None, Sketch.const.INITIALIZE)

    application = SketchApplication(filename, options.display,
				    options.geometry)
    Sketch.Issue(None, Sketch.const.APP_INITIALIZED, application)
    application.Run()
    application.SavePreferences()
