/***************************************************************************
                          rlayerwidget.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rlayerwidget.h 1998/08/24 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RLAYERWIDGET_H
#define RLAYERWIDGET_H

#include <qlistbox.h>

#include "rgraphic.h"
#include "rlistboxitem.h"
#include "rwidget.h"

class QToolButton;

class RLayerWidget : public RWidget
{
  Q_OBJECT
public:
  RLayerWidget(bool _rw,
               QWidget* _parent=0, 
               const char* _name=0, 
               WFlags _f=0);
  ~RLayerWidget();

  void resizeChildren();

  void      setGraphic(RGraphic* _graphic);
  RGraphic* getGraphic() { return graphic; }
  QSize     sizeHint() const;

protected:
  virtual void resizeEvent(QResizeEvent* _ev);
    
public slots:
  virtual void show();
  void updateLayerList();
  void switchLayer(int);
  void selectLayer(int);
  void selectLayer(const char* _name);
  void addLayer();
  void removeLayer();
  void renameLayer();
  void showLayers();
  void hideLayers();
  void removeEmptyLayers();
  void showHideAllLayers(bool _show);

signals:
  void layerSwitched(const char*);
  void layerSelected(const char*);

private:
  RGraphic* graphic;              // Pointer to graphic
  QListBox* layerList;            // The layer list
  
  QPixmap* pxmVisible;            // Pixmap for visible layers
  QPixmap* pxmHidden;             // Pixmap for hidden layers

  QToolButton*  bAddLayer;        // tool button add layer
  QToolButton*  bRemoveLayer;     //             remove layer
  QToolButton*  bRenameLayer;     //             rename layer
  QToolButton*  bShowLayers;      //             show all layers
  QToolButton*  bHideLayers;      //             hide all layers
  QToolButton*  bRemoveEmptyLayers;  //          remove empty layers
  QFrame*       fSep1;            // seperator
  
};


#endif

// EOF



