/***************************************************************************
                          rattribdialog.cpp  -  description
                             -------------------
    begin                : Tue Sep 28 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/



#include "rattribdialog.h"
#include "rlabel.h"

#include "rconfig.h"

/**
 * Constructor
 */
RAttribDialog::RAttribDialog(const char* _caption,
                             const char* _label,
                             QWidget* _parent)
  :QDialog(_parent, _caption, true, WStyle_NormalBorder)
{
  setCaption(_caption);

  setFixedSize(DEF_ATTRIBDLG_WIDTH, DEF_ATTRIBDLG_HEIGHT+20);

  // Create label:
  //
  lText = new RLabel(_label, this, "ltext");
  lText->setAlignment(AlignCenter);
  if(lText->sizeHint().width()+20>DEF_ATTRIBDLG_WIDTH) {
    setFixedWidth(lText->sizeHint().width()+20);
  }
  if(lText->sizeHint().height()+70>DEF_ATTRIBDLG_HEIGHT) {
    setFixedHeight(lText->sizeHint().height()+70);
  }
  lText->setGeometry(10, 10, width()-10, 30);

  // Create labels:
  //
  RLabel* lab = new RLabel(RMES(425), this);
  lab->setGeometry(10, 60, (width()-20)/3, 20);

  lab = new RLabel(RMES(426), this);
  lab->setGeometry(10+(width()-20)/3, 60, (width()-20)/3, 20);

  lab = new RLabel(RMES(427), this);
  lab->setGeometry(10+(width()-20)/3*2, 60, (width()-20)/3, 20);

  // Create comboboxes:
  //
  cbColor = new RComboBox(false, this, "color");
  cbColor->fillInColors();
  cbColor->insertItem(RMES(443));
  cbColor->setEditText(RMES(443));
  QToolTip::add(cbColor, RMES(425));
  cbColor->setGeometry(10, 80, (width()-20)/3, 20);

  cbWidth = new RComboBox(false, this, "width");
  cbWidth->fillInWidths();
  cbWidth->insertItem(RMES(443));
  cbWidth->setEditText(RMES(443));
  QToolTip::add(cbWidth, RMES(426));
  cbWidth->setGeometry(10+(width()-20)/3, 80, (width()-20)/3, 20);

  cbStyle = new RComboBox(false, this, "width");
  cbStyle->fillInStyles();
  cbStyle->insertItem(RMES(443));
  cbStyle->setEditText(RMES(443));
  QToolTip::add(cbStyle, RMES(427));
  cbStyle->setGeometry(10+(width()-20)/3*2, 80, (width()-20)/3, 20);

  // Create buttons:
  //
  bOk = new QPushButton(RMES(46), this);
  bOk->setGeometry(width()-150, 110, 70, 20);
  bOk->setAccel(Key_Return);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));

  bCancel = new QPushButton(RMES(47), this);
  bCancel->setGeometry(width()-80, 110, 70, 20);
  bCancel->setAccel(Key_Escape);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));

  /*
  bHelp = new QPushButton(RMES(48), this);
  bHelp->setGeometry(10+(width()-20)/3*2, 110, (width()-20)/3, 20);
  bHelp->setAccel(Key_F1);
  */
}


/**
 * Destructor
 */
RAttribDialog::~RAttribDialog()
{

}



// Get the chosen color or -1 if no color was chosen:
//
int
RAttribDialog::getColor()
{
  if(cbColor) {
    if(cbColor->currentText().isNull()) {
      return cbColor->currentItem();
    }
  }

  return -1;
}



// Get the chosen width or -1 if no width was chosen:
//
int
RAttribDialog::getWidth()
{
  if(cbWidth) {
    if(cbWidth->currentText().isNull()) {
      return cbWidth->currentItem();
    }
  }

  return -1;
}


// Get the chosen style or -1 if no style was chosen:
//
int
RAttribDialog::getStyle()
{
  if(cbStyle) {
    if(cbStyle->currentText().isNull()) {
      return cbStyle->currentItem();
    }
  }

  return -1;
}










