/***************************************************************************
                          raboutdialog.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Apr 28 1999                                           
    copyright            : (C) 1999 by Andreas Mustun                         
    email                : mustun@ribbonsoft.com                                     
 ***************************************************************************/


#include <qkeycode.h>
#include <qlayout.h>
#include <qpixmap.h>

#include "raboutdialog.h"
#include "rlabel.h"
#include "rprgdef.h"
#include "rpushbutton.h"

#ifdef DEF_QCAD
#include "xpm/qcad.xpm"
#include "xpm/apsicon.xpm"
#endif

#ifdef DEF_CAM_EXPERT
#include "xpm/camexpert.xpm"
#include "xpm/firmicon.xpm"
#endif


/*! \class RAboutDialog
    \brief The "Help" -> "About" Dialog

    \author Andrew Mustun
*/


/*! Constructor
    \param _parent The Parent Widget
    \param _name Name
*/
RAboutDialog::RAboutDialog(QWidget* _parent,
                           const char* _name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  setFixedSize(350, 194);

  setCaption(DEF_APPNAME);

  // Stuff the elements into a box layout:
  //
  QGridLayout * gl = new QGridLayout(this, 4, 2, 5);
    gl->setColStretch(0, 2);
    gl->setColStretch(1, 5);

    gl->setRowStretch(0, 1);
    gl->setRowStretch(1, 20);
    gl->setRowStretch(2, 20);
    gl->setRowStretch(3, 6);

  // Program:
  //
  fProg = new QFrame(this, "fprog");
  fProg->setFrameStyle(QFrame::Box|QFrame::Sunken);
  gl->addMultiCellWidget(fProg, 1, 1, 0, 1);

  QGridLayout* glp = new QGridLayout(fProg, 1, 2, 5);
    glp->setColStretch(0, 1);
    glp->setColStretch(1, 3);

    lIconProg = new RLabel(fProg, "liconprog");
    lIconProg->setPixmap(QPixmap(DEF_APP_ICON));
    lIconProg->setAlignment(AlignHCenter|AlignTop);
    glp->addWidget(lIconProg, 0, 0);

    QCString mes(1024);
    mes.sprintf("%s\nVersion: %s\nReleased: %s\nAll rights reserved.",
                DEF_APPNAME,
                DEF_VERSION,
                DEF_RELEASE);
    lInfoProg = new RLabel(mes.data(), fProg, "linfoprog");
    lInfoProg->setAlignment(AlignTop);
    glp->addWidget(lInfoProg, 0, 1);

  // Firm:
  //
  fFirm = new QFrame(this, "ffirm");
  fFirm->setFrameStyle(QFrame::Box|QFrame::Sunken);
  gl->addMultiCellWidget(fFirm, 2, 2, 0, 1);

  QGridLayout* glf = new QGridLayout(fFirm, 1, 2, 5);
    glf->setColStretch(0, 1);
    glf->setColStretch(1, 3);

    lIconFirm = new RLabel(fFirm, "liconfirm");
    lIconFirm->setPixmap(QPixmap(DEF_ORG_ICON));
    lIconFirm->setAlignment(AlignHCenter|AlignTop);
    glf->addWidget(lIconFirm, 0, 0);

    mes.sprintf("Copyright by %s\n%s\nSupport: %s\nInternet: %s",
                DEF_FIRM,
                DEF_PROGRAMMER,
                DEF_SUPPORTEMAIL,
                DEF_INTERNET);
    lInfoFirm = new RLabel(mes.data(), fFirm, "linfofirm");
    lInfoFirm->setAlignment(AlignTop);
    glf->addWidget(lInfoFirm, 0, 1);

  bOk = new RPushButton("OK", this);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));
  bOk->setAccel(Key_Return);
  gl->addMultiCellWidget(bOk, 3, 3, 0, 1);

}



/*! Destructor
*/
RAboutDialog::~RAboutDialog()
{

}


// EOF-




