// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLImageFormat.h

  Stephane Rehel

  September 20 1997
*/

#ifndef __MLImageFormat_h
#define __MLImageFormat_h

#include "tools/boolean.h"
#include "tools/MLString.h"

class MLImage;

/////////////////////////////////////////////////////////////////////////////

class MLImageFormat
{
public:
  enum FORMAT
       {
       NULL_FMT= 0,

       JPG,
       TIF,
       GIF,
       RGB,
       TGA,
       PNM,
       BMP,

       LAST_FMT
       };

public:
  static int getNFormats();

  // 1 <= i <= nFormats
  static FORMAT getFromIndex( int i );

  static MLString getName( FORMAT fmt );

  static FORMAT getFromName( const MLString& name );

  static MLString getExtension( FORMAT fmt );

  static FORMAT getFromFilename( const MLString& filename );

  static boolean availableReader( FORMAT fmt );
  static boolean availableWriter( FORMAT fmt );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLImageFormat_h
