/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 Ondrejicka Stefan			   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef chbg_config_h_
#define chbg_config_h_

#include <glib.h>
#include <gdk/gdk.h>

#ifdef GETTEXT_NLS
#include <libintl.h>
#else
#define gettext(x) x
#endif

#define NUM_EFECTS 29
#define NUM_SHADERS 62

typedef enum {
	TILE ,
	MIRROR ,
	CENTER ,
	MAXIMIZE ,
	MAX_ASP_RATIO_CENTER ,
} shtype;

#define default_max_grow 2.0	/*** maximal grow ratio ***/
#define default_interval 5	/*** time for which will picture stay on screen ***/
#define default_max_size 90	/*** maximal size of picture in % of screen size ***/
#define default_type MAX_ASP_RATIO_CENTER  /*** type of picture rendering ***/
#define default_efect 1
#define default_shader 0
#define default_speed 100

typedef struct {
	gfloat		max_grow;
	gfloat		interval;
	shtype		type;
	guint		efect;
	guint		max_size;
	GdkColor	background;
	GdkColor	background2;
	guint		shade;
	guint		rand_colors;
} propt;

typedef struct {
	gchar	*name;
	propt	*prop;
} picentry;

typedef struct {
	propt		properties;
	GSList		*pics;
	guint		num_pics;
	guint		screensaver;
	guint		xscreensaver;
	guint		blank;
	guint		setup;
	guint		randomize;
	guint		recurse;
	guint		speed;
	gchar		*scenario;
	guint		inwindow;
	glong		windowid;
	guint		runit;
	GSList		*pattern;
	guint		cycle_blank;
} cfg_param;

extern gint cfg_cmdln(guint , gchar **);
extern gint cfg_scenario(gchar *);
extern gint cfg_save_scenario(gchar *);
extern void cfg_default(void);
extern void cfg_usage(gchar *);

extern void run_setup(guint *, gchar ***);

extern cfg_param cfg;

#endif
