#include "SavanttextType.hh"
#include "SavantlineType.hh"

SavanttextType::SavanttextType(VHDLKernelBase *proc, const char *fileName, const _savant_file_open_kind &mode)  {
  openFile(proc, fileName, mode);
}

SavanttextType::SavanttextType(VHDLKernelBase *proc, const ArrayType& fileName, const _savant_file_open_kind &mode)  {
  openFile(proc, (const char*)fileName.getString(), mode);
}

int
savantwrite(VHDLKernelBase *base, SavanttextType& file, SavantstringType& var)  {
  SavantlineType line;
  
  var.savantwrite(line);
  return file.savantwriteline(base, line);
}

int
savantread(VHDLKernelBase *base, SavanttextType& file, SavantstringType& var)  {
  SavantlineType line;

  file.savantreadline(base, line);
  return var.savantread(line);
}

const EnumerationType&
savantendfile_boolean(VHDLKernelBase *base, SavanttextType& file)  {
  if (file.savantendfile_boolean(base, file.get_fileHandle()) == SAVANT_BOOLEAN_TRUE) {
    return SAVANT_BOOLEAN_TRUE;
  }

  return SAVANT_BOOLEAN_FALSE;
}

int
savantfile_close(VHDLKernelBase *base, SavanttextType& file) {
  file.closeFile(base);

  return NORMAL_RETURN;
}

int
savantread(VHDLKernelBase *base, SavanttextType& file, SavantstringType& var, IntegerType &count)  {
  SavantlineType line;
  file.savantreadline(base, line, count);
  return var.savantread(line);
}
