//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef SAVANTSTRINGTYPE_HH
#define SAVANTSTRINGTYPE_HH

#include "ArrayType.hh"
#include "VectorBase.hh"
#include "SavantstringType_event.hh"
#include "SavantstringType_lastevent.hh"

// VHDL:
//    type string is array(natural range <>) of character;
// C++:

extern rangeInfo SavantstringType_rangeInfo[];
extern arrayTypeInfo SavantstringType_info;

class SavantstringType : public ArrayType {
public:
  SavantstringType() : ArrayType () {}
  SavantstringType(ObjectBase::ObjectType, const TypeInfo& =
		   TypeInfo::NULL_TYPE_INFO);
  SavantstringType(ObjectBase::ObjectType objType, 
		   int left, ArrayDirn_t dirn, int right, const TypeInfo& =
		   TypeInfo::NULL_TYPE_INFO);
  SavantstringType(ObjectBase::ObjectType objType, 
		   int left, ArrayDirn_t dirn, int right, char* value,
		   const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  SavantstringType(ObjectBase::ObjectType objType, char* value,
		   const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  SavantstringType(ObjectBase::ObjectType objType,int left, ArrayDirn_t dirn, int right, const SavantstringType &tmp);  
  SavantstringType(ObjectBase::ObjectType objType, const SavantstringType& value);
  //Constructor for alias initialization
  SavantstringType(bool alias, ObjectBase::ObjectType objType,
		   int left, ArrayDirn_t dirn, int right, 
		   const ArrayType& actual,
		   const ArrayInfo& boundsOfActual);
  //Constructor for aggregate initialization
  SavantstringType(ObjectBase::ObjectType objType, 
		   int left, ArrayDirn_t dirn, int right,
		   int noofElmntAssns, ...);

  SavantstringType(const SavantstringType& value);
    virtual ~SavantstringType();

  SavantstringType& getSlice(const ArrayInfo&);

  VHDLType& operator=(const VHDLType& val);
  VHDLType& operator[](const int) const;
  EnumerationType& operator[](const ScalarType&) const;
  SavantstringType& operator=(const SavantstringType& val);
  VHDLType& operator=(const char *str);

  void print(ostream& os) const { object->print(os); }
  const ScalarType LEFT_O(const IntegerType& n) const;
  const ScalarType RIGHT_O(const IntegerType& n) const;
  const ScalarType HIGH_O(const IntegerType& n) const;
  const ScalarType LOW_O(const IntegerType& n) const;
  const IntegerType LENGTH_O(const IntegerType& n) const;
  const EnumerationType ASCENDING_O(const IntegerType& n) const;
};

extern ostream& operator << (ostream&, const SavantstringType&);
extern EnumerationType
savantEqual(const SavantstringType &, const SavantstringType &);
extern EnumerationType
savantNotEqual(const SavantstringType &, const SavantstringType &);
extern EnumerationType
savantLessThan(const SavantstringType &, const SavantstringType &);
extern EnumerationType
savantLessThanOrEqual(const SavantstringType &, const SavantstringType &);
extern EnumerationType
savantGreaterThan(const SavantstringType &, const SavantstringType &);
extern EnumerationType
savantGreaterThanOrEqual(const SavantstringType &, const SavantstringType &);

extern SavantstringType
conCatenate(const VHDLType&, const VHDLType&);

extern SavantstringType
savantConcatenate(const SavantstringType&, const SavantstringType&);

extern SavantstringType
savantConcatenate(const EnumerationType&, const SavantstringType&);

extern SavantstringType
savantConcatenate(const SavantstringType&, const EnumerationType&);

extern SavantstringType
savantConcatenate(const EnumerationType&, const EnumerationType&, SavantstringType*);

#endif
