#include "CWSignalData.hh"

CWSignalData::~CWSignalData() {
  delete val;
}

// All of these constructors should malloc enough space for largest signal
// in certain cases. If we are constructing a class wide signal for an rval
// of an assignment statement then the fore mentioned need not be considered.
// If we are actually constructing a class wide signal, it is definitely a
// consideration. Calls of malloc(200) are purely for test purposes - a 
// proper implementation must find the largest signal in the class hierarchy.

CWSignalData::CWSignalData() {
   val = (TaggedRecord *) malloc(200);
}

CWSignalData::CWSignalData(const TaggedRecord& t) { 

#ifdef CLASS_WIDE
    val = (TaggedRecord *) malloc(t.get_size());
#else
    val = (TaggedRecord *) malloc(200);
#endif
  memcpy(val, &t, t.get_size());
}

CWSignalData::CWSignalData(const CWSignalData& c) {

#ifdef CLASS_WIDE
      val = (TaggedRecord *) malloc(c.val->get_size());
#else
      val = (TaggedRecord *) malloc(200);
#endif
    memcpy(val, c.val, c.val->get_size());
}

VHDLData&
CWSignalData::operator=(const VHDLData& d) {
  // This very much depends on the r-value of the signal assignment statement

    // can always wrap some class wide wrapper around a tagged type variable
    // Very experimental seeing as signals and variables can be rvals.

    memcpy(val, ((CWSignalData *) &d)->val,
	   ((CWSignalData *) &d)->val->get_size());
    return ((VHDLData &) (*this));

}

void
CWSignalData::print(ostream& os) const {
  int numberOfFields = val->numberOfFields;

  for(register field_number = 1; field_number <= numberOfFields; 
      field_number++) {

    val->get_field(field_number).print(os);

  }
}
  
bool 
CWSignalData::operator!=(const VHDLData& d) const {
  
  if (((CWSignalData &) d).val->numberOfFields != val->numberOfFields) {
    return true;
  }

  if (((CWSignalData &) d).val->tag != val->tag) {
    return true;
  }

  if (*val == *((CWSignalData &) d).val) {
    return false;
  }
  else {
    return true;
  }
}




