//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: BitVector.cc,v 1.43 1999/03/09 22:52:01 dmartin Exp $
//---------------------------------------------------------------------------


template <int left, ArrayDirn_t dirn, int right>
inline
savantBitVector<left, dirn, right>::savantBitVector() : VectorBase(left, dirn, right) {
  register int i;
  for (i = 0; i < numbits; i++) { bv[i] = '0'; }
}


template <int left, ArrayDirn_t dirn, int right>
inline
savantBitVector<left, dirn, right>::savantBitVector(bool init) : VectorBase(left, dirn, right) {
  register int i;

  if (init == false) {
    for (i = 0; i < numbits; i++) { bv[i] = '0'; }
  }
  else {
    for (i = 0; i < numbits; i++) { bv[i] = '1'; }
  }
}


template <int left, ArrayDirn_t dirn, int right>
inline
savantBitVector<left, dirn, right>::savantBitVector(char init) 
  : VectorBase(left, dirn, right) {
#ifdef DEVELOPER_ASSERTIONS
  if (init != '0' && init != '1') {
    cerr << "BitVector::BitVector(char): illegal argument ("
	 << init << ")" << endl;
    abort();
  }
#endif
  for (register int i = 0; i < numbits; i++) { bv[i] = init; }
}


template <int left, ArrayDirn_t dirn, int right>
inline
savantBitVector<left, dirn, right>::
 savantBitVector(const savantBitVector<left, dirn, right>& b) 
  : VectorBase(left, dirn, right) {
  for (register int i = 0; i < numbits; i++) { bv[i] = b.bv[i]; }
}


template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>&
savantBitVector<left, dirn, right>::operator=(const savantBitVector<left, dirn, right>& rhs) {
  for (register int i = 0; i < numbits; i++) {
    bv[i] = rhs.bv[i];
  }
  return *this;
}


// initialize bit vector with a string of '0's and '1's
template <int left, ArrayDirn_t dirn, int right>
inline VectorBase&
savantBitVector<left, dirn, right>::operator=(char* initstr) {
  register int initlen, index;

  initlen = strlen(initstr);
#ifdef DEVELOPER_ASSERTIONS
  if (initlen > numbits) {
    cerr << "savantBitVector<" << numbits 
	 << ">::operator= error--input string too long (" << initlen 
	 << ")" << endl;
    abort();
  }
#endif

  for (index = 0; index < initlen; index++) {
#ifdef DEVELOPER_ASSERTIONS
    if (!(initstr[index] == '0' || initstr[index] == '1')) {
      cerr << "Invalid character in BitVector::operator(char*) (= " 
	   << initstr[index] << ")" << endl;
      abort();
    }
#endif
    bv[index] = initstr[index];
  }
  for (index = initlen; index < numbits; index++) {
    bv[index] = '0';
  }
  return *this;
}


// set all bits to a boolean value
template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>&
savantBitVector<left, dirn, right>::operator=(bool b) {
  register int i;

  if (b == true) {
    for (i = 0; i < numbits; i++) { bv[i] = '1'; }
  }
  else {
    for (i = 0; i < numbits; i++) { bv[i] = '0'; }
  }
  return *this;
}


// set all bits to a character value--it better be '0' or '1'
template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>&
savantBitVector<left, dirn, right>::operator=(char c) {
  register int i;

#ifdef DEVELOPER_ASSERTIONS
  if (!(c == '0' || c == '1')) {
    cerr << "Invalid character in BitVector::operator(char) (= " 
	 << c << ")" << endl;
    abort();
  }
#endif
  for (i = 0; i < numbits; i++) { bv[i] = c; }
  return *this;
}


template <int left, ArrayDirn_t dirn, int right>
inline bool
savantBitVector<left, dirn, right>::operator==(char c) const {
  if (numbits != 1) {
    cerr << "bit_vector::operator==(char) only valid for length 1!" << endl;
    cerr << "My length is " << numbits << endl;
    abort();
  }
  return (bv[0] == c);
}


template <int left, ArrayDirn_t dirn, int right>
inline bool
savantBitVector<left, dirn, right>::operator!=(const VHDLData& d) const {

  savantBitVector<left, dirn, right> vec = *(savantBitVector<left, dirn, right>*)&d;
  if (numbits != vec.numbits) {
    return true;
  }
  else {
    for (register int i = 0; i < numbits; i++) {
      if (bv[i] != vec.bv[i]) {
	return true;
      }
    }
    return false;
  }
}


template <int left, ArrayDirn_t dirn, int right>
 void 
savantBitVector<left, dirn, right>::assignSlice(VHDLData* data,
						   const ArrayInfo* sInfo, 
						   const ArrayInfo *dInfo) {
  int destidx, srcidx;
  VectorBase* srcvec = (VectorBase*)data;

  destidx = dInfo->left();
  srcidx = sInfo->left(); 
  if (dInfo->length() < sInfo->length()) {
    cerr << "BitVector::assignSlice ERROR--" << *sInfo
         << " is too long to fit into me." << endl;
    cerr << *this << endl;
    abort();
  }
  else { // data is equal or shorter in length than me
    while (srcidx != sInfo->right()) {
      bv[destidx] = (*srcvec)[srcidx];
      destidx = dInfo->rightof(destidx);
      srcidx = sInfo->rightof(srcidx);
    }
    bv[destidx] = (*srcvec)[srcidx]; // have to do this to do the last one
  }
}


template <int left, ArrayDirn_t dirn, int right>
 void 
savantBitVector<left, dirn, right>::assignSlice(VHDLData* data,
						   const ArrayInfo* dInfo) {
  int destidx, srcidx;
  VectorBase* srcvec = (VectorBase*)data;

  destidx = dInfo->left();
  srcidx = srcvec->bounds.left(); 
  if (bounds.length() < dInfo->length()) {
    cerr << "BitVector::assignSlice ERROR--" << *dInfo
         << " is too long to fit into me." << endl;
    cerr << *this << endl;
    abort();
  }
  else { // data is equal or shorter in length than me
    while (destidx != dInfo->right()) {
      bv[destidx] = (*srcvec)[srcidx];
      destidx = dInfo->rightof(destidx);
      srcidx = srcvec->bounds.rightof(srcidx);
    }
    bv[destidx] = (*srcvec)[srcidx]; // have to do this to do the last one
  }
}


template <int left, ArrayDirn_t dirn, int right>
inline char&
savantBitVector<left, dirn, right>::operator[](const int pos) {
#ifdef DEVELOPER_ASSERTIONS
  if (!bounds.contains(pos)) {
    cerr << "savantBitVector::operator[]: bit specifier (" << pos 
	 << ") out of range--my bounds are " << bounds << endl;
    abort();
  }
#endif
  register int i = bounds.storageIndex(pos);
  return bv[i];
}


template <int left, ArrayDirn_t dirn, int right>
inline void
savantBitVector<left, dirn, right>::print(ostream& os) const {
  for (register int i = 0; i < numbits; i++) {
    os << bv[i];
  }
}

template <int left, ArrayDirn_t dirn, int right>
inline ostream& operator<<(ostream& os, const savantBitVector<left, dirn, right> &b) {
  for (register int i = 0; i < b.numbits; i++) {
    os << b.bv[i];
  }
  return os;
}


template <int left, ArrayDirn_t dirn, int right>
bool
savantEqual(const savantBitVector<left, dirn, right>& lhs, 
	   const savantBitVector<left, dirn, right>& rhs) {
  if (lhs.numbits != rhs.numbits) {
    return false;
  }
  for (register int i = 0; i < lhs.numbits; i++) {
    if(lhs.bv[i] != rhs.bv[i]) {
      return false;
    }
  }
  return true;
}


template <int left, ArrayDirn_t dirn, int right>
bool
savantEqual(const savantBitVector<left, dirn, right>& lhs, 
	   const char& rhs) {
  return savantEqual(lhs, savantBit(rhs));
}


template <int left, ArrayDirn_t dirn, int right>
bool
savantNotequal(savantBitVector<left, dirn, right>& vec1, 
	   savantBitVector<left, dirn, right>& vec2) {
  return !( savantEqual(vec1, vec2) );
}


template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>
savantNot(const savantBitVector<left, dirn, right>& rhs) {
  savantBitVector<left, dirn, right> retval;
  for (register int i = 0; i < rhs.numbits; i++) {
    if (rhs.bv[i] == '0') {
      retval.bv[i] = '1';
    }
    else {
      retval.bv[i] = '0';
    }
  }
  return retval;
}


template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>
savantAnd(const savantBitVector<left, dirn, right>& lhs, 
	      const savantBitVector<left, dirn, right>& rhs) {
  savantBitVector<left, dirn, right> retval;
  for (register int i = 0; i < rhs.numbits; i++) {
    if (lhs.bv[i] == '1' && rhs.bv[i] == '1') {
      retval.bv[i] = '1';
    }
    else {
      retval.bv[i] = '0';
    }
  }
  return retval;
}


template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>
savantOr(const savantBitVector<left, dirn, right>& lhs, 
	     const savantBitVector<left, dirn, right>& rhs) {
  savantBitVector<left, dirn, right> retval;

  for (register int i = 0; i < rhs.numbits; i++) {
    if (lhs.bv[i] == '1' || rhs.bv[i] == '1') {
      retval.bv[i] = '1';
    }
    else {
      retval.bv[i] = '0';
    }
  }
  return retval;
}


template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>
savantNand(const savantBitVector<left, dirn, right>& lhs, 
	       const savantBitVector<left, dirn, right>& rhs) {
  return !savantAnd(lhs, rhs);
}

 
template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>
savantNor(const savantBitVector<left, dirn, right>& lhs, 
	      const savantBitVector<left, dirn, right>& rhs) {
  return !savantOr(lhs, rhs);
}


template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>
savantXor(const savantBitVector<left, dirn, right>& lhs, 
	      const savantBitVector<left, dirn, right>& rhs) {
  savantBitVector<left, dirn, right> retval;

  for (register int i = 0; i < rhs.numbits; i++) {
    if ((lhs.bv[i] == '1' && rhs.bv[i] == '0') || 
	(lhs.bv[i] == '0' && rhs.bv[i] == '1')) {
      retval.bv[i] = '1';
    }
    else {
      retval.bv[i] = '0';
    }
  }
  return retval;
}


template <int left, ArrayDirn_t dirn, int right>
inline savantBitVector<left, dirn, right>
savantXnor(const savantBitVector<left, dirn, right>& lhs, 
	       const savantBitVector<left, dirn, right>& rhs) {
  return !savantXor(lhs, rhs);
}
