//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef ACCESSVARIABLE_HH
#define ACCESSVARIABLE_HH

#include "vhdl.hh"
#include "ObjectBase.hh"
#include "ArrayInfo.hh"
#include "Types.hh"
#include <string.h>

struct AccessVarBase : public VHDLData{
  char* name;
  VarType variableType;  // normal or access type
  int dataLength;		// length of data pointed to
  virtual int length() const { return dataLength; }

  AccessVarBase() {}
  AccessVarBase(char* newname) : name(newname) {
    variableType = NORMAL;
    dataLength = 0;
  }
  AccessVarBase(const AccessVarBase&);

  virtual VHDLData::UniversalType get_universal_kind() const{
    return ACCESS_VARIABLE;
  }
};

// Temporary Solution:  AccessVariable must be derived from VarBase or 
// ObjectBase.
template <class Type>
class AccessVariable : public AccessVarBase {
public:
  AccessVariable();
  AccessVariable(char*);
  AccessVariable(const AccessVariable<char*>&);
  ~AccessVariable() { delete [] val; }
  AccessVariable<char*>& operator=(const AccessVariable<char*>&);
  AccessVariable<char*>& operator=(const char*);
  void print(ostream& os = cout) const;
  int getSize() const { return sizeof(*this); }
  bool operator != (const VHDLData& data) const {
    return INT_TO_BOOL(!((((AccessVariable<Type>&) data).curPos == curPos) &&
			 (((AccessVariable<Type>&) data).val == val)));
  }

  // WARNING: This method will work ONLY for AccessVariable<char*>.
  inline void printstr(ostream& os) {
    os.write(val, dataLength);
  }

//   VHDLData& readVal(void) {
//     return val;
//   }
//   void updateVal(VHDLData& value) {
//     val = value;
//   }

//   ObjectBase& operator=(const ObjectBase& obj) {
//     val = obj.readVal();
//     curPos = obj.curPos;
//   }

  int curPos; // pointer into val indicating, e.g., the current read position
  Type val;

private:
  void init();
};

#include "AccessVariable.cc"

#endif
