
// Copyright (c) 1995-1999 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: scram.cc,v 1.2 1999/03/09 20:57:25 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "scram.hh"
#include "savant.hh"
#include "symbol_table.hh"
#include "IIR_DesignFile.hh"
#include "VHDLLexer.hh"
#include "VHDLParser.h"
#include "error_func.hh"
#include <strstream.h>

extern bool ignore_standard_library;
extern bool verbose_output;
extern bool standard_fir;

library_manager *
scram::my_library_manager;

scram::scram( library_manager *init_library_manager ){
  need_to_write_libraries = true;
  my_library_manager = init_library_manager;
  IIR::_set_library_manager( init_library_manager );

  make_ready();
}

scram::scram(  ){
  need_to_write_libraries = false;

  ASSERT( my_library_manager != NULL );
  make_ready();
}

scram::~scram(){
  delete my_symbol_table;
  my_symbol_table = NULL;
}

void 
scram::make_ready( ){
  my_symbol_table = new symbol_table();
}


IIR_DesignFileList *
scram::parse_files( int file_count, char **filenames ){
  IIR_DesignFileList *return_list = &IIR_DesignFile::design_files;  

  int i;
  for (i = 1; i < file_count; i++) {
    cerr << "Processing file " << filenames[i] << endl;

    IIR_DesignFile *parsed_file = parse_file( filenames[i],
					      get_library_manager()->get_work_library() );
    IIR_DesignFile::design_files.append( parsed_file );
  }
  
  return return_list;
}

IIR_DesignFile *
scram::parse_file( char *filename, IIR_LibraryDeclaration *lib ){
  ifstream yyin( filename );

  if( verbose_output == true ){
    cerr << "Parse_file parsing " << filename << endl;
  }

  if (yyin == NULL) {
    ostrstream err;
    err << "Error opening file " << filename << ends;
    report_error( err );
    exit( 1 );
  } 

  IIR_DesignFile *vhdl_design_file = new IIR_DesignFile();
  vhdl_design_file->_set_parser( this );
  vhdl_design_file->_set_library_manager( get_library_manager() );
  vhdl_design_file->_set_file_name( filename );

  VHDLLexer scan( &yyin );
  ANTLRTokenBuffer pipe(&scan);
  scan.resetLexerFileLocators(filename);

  VHDLParser parser(&pipe);
  parser.init();
  parser.setEofToken(ENDFILE);

  parser.design_file( vhdl_design_file, my_symbol_table, lib, need_to_write_libraries );

  yyin.close();

  return vhdl_design_file;
}

