// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ReverseRangeAttribute.cc,v 1.4 1999/10/07 14:05:07 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_ReverseRangeAttribute.hh"
#include "IIR_AscendingAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_LeftAttribute.hh"
#include "IIR_RightAttribute.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_TypeDeclaration.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"

IIRScram_ReverseRangeAttribute::~IIRScram_ReverseRangeAttribute() {}

void 
IIRScram_ReverseRangeAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'REVERSE_RANGE ";

  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ") ";
  }
}

void
IIRScram_ReverseRangeAttribute::_publish_vhdl_range(ostream& _vhdl_out) {
  _publish_vhdl(_vhdl_out);
}

void 
IIRScram_ReverseRangeAttribute::_publish_cc_range() {
  ASSERT(get_prefix() != NULL);

  IIR_LeftAttribute *left_attr = new IIR_LeftAttribute();
  copy_location( this, left_attr );
  left_attr->set_prefix(get_prefix());
  left_attr->set_suffix(get_suffix());
  
  IIR_AscendingAttribute *ascending_attr = new IIR_AscendingAttribute();
  copy_location( this, ascending_attr );
  ascending_attr->set_prefix(get_prefix());
  ascending_attr->set_suffix(get_suffix());

  IIR_RightAttribute *right_attr = new IIR_RightAttribute();
  copy_location( this, right_attr );
  right_attr->set_prefix(get_prefix());
  right_attr->set_suffix(get_suffix());

  right_attr->_publish_cc_value();
  _cc_out << ", ((";
  ascending_attr->_publish_cc() ;
  _cc_out << " == SAVANT_BOOLEAN_TRUE)? downto : to), ";
  left_attr->_publish_cc_value();

  delete left_attr;
  delete ascending_attr;
  delete right_attr;
  ASSERT(get_prefix() != NULL);	// Debug
}


IIR_TextLiteral *
IIRScram_ReverseRangeAttribute::_build_attribute_name() {
  char *name = "reverserange";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_ReverseRangeAttribute::_get_subtype(){
  // This is copied (and modified) from IIR_RangeAttribute...
  IIR_TypeDefinition *prefix_rval = _get_prefix_subtype();

  ASSERT( prefix_rval->_is_array_type() == TRUE );

  IIR_ScalarTypeDefinition *index_type = prefix_rval->_get_index_subtype();
  
  if( _my_rval == NULL ){
    IIR *cloned = prefix_rval->_get_index_subtype()->_clone();
    ASSERT( cloned->_is_scalar_type() == TRUE && cloned->_is_type_definition() == TRUE );
    _my_rval = (IIR_ScalarTypeDefinition *)cloned;
    
    _my_rval->set_base_type( index_type->get_base_type() );
    _my_rval->set_left( index_type->get_right() );
    _my_rval->set_right( index_type->get_left() );

    if( index_type->get_direction() != NULL ){
      if( index_type->_is_ascending_range() == TRUE ){
	IIR_EnumerationLiteral *false_lit = get_false_literal( _get_symbol_table() );
	_my_rval->set_direction( (IIR*)false_lit );
      }
      else{
	IIR_EnumerationLiteral *true_lit = get_true_literal( _get_symbol_table() );
	_my_rval->set_direction( (IIR*)true_lit );
      }
    }
  }
   
  return _my_rval;
}


IIR_Declaration *
IIRScram_ReverseRangeAttribute::_get_implicit_declaration( char *decl_name,
							   IIR_TypeDefinition * ){
  // This is copied (and modified) from IIR_RangeAttribute...
  IIR_TypeDefinition *prefix_rval = _get_prefix_subtype( &IIR::_is_array_type );
  return _build_type_declaration( decl_name, prefix_rval );
}


IIR_TypeDefinition *
IIRScram_ReverseRangeAttribute::_get_prefix_rval(){
  return _get_prefix_rval_range_attributes();
}


IIR *
IIRScram_ReverseRangeAttribute::_get_suffix(){
  return get_suffix();
}

void 
IIRScram_ReverseRangeAttribute::_resolve_suffix_special(){
  _resolve_suffix_local_static_int();
}
