
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_OthersInitialization.cc,v 1.2 1999/03/09 20:55:45 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_OthersInitialization.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_ElementDeclarationList.hh"
#include "IIR_ElementDeclaration.hh"
#include "IIR_TextLiteral.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "symbol_table.hh"

extern bool parse_error;

IIRScram_OthersInitialization::~IIRScram_OthersInitialization(){}

void 
IIRScram_OthersInitialization::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_subtype() != NULL);
  if (get_subtype()->_is_record_type() == TRUE) {
    _vhdl_out << " (";
  }
  _vhdl_out << "others => ";

  ASSERT(get_expression() != NULL);
  ASSERT(get_expression()->_is_resolved() == TRUE);
  get_expression()->_publish_vhdl(_vhdl_out);
  if (get_subtype()->_is_record_type() == TRUE) {
    _vhdl_out << ")";
  }
}

void 
IIRScram_OthersInitialization::_publish_cc_headers() {
  ASSERT(get_expression() != NULL);
  get_expression()->_publish_cc_headers();
}

void 
IIRScram_OthersInitialization::_publish_cc_initialization_value() {
  _cc_out << "1";
  _cc_out << ", ";
  _cc_out << " new ElementAssociation(Others, ";
  if (get_expression()->get_kind() == IIR_CONSTANT_DECLARATION) {
    _cc_out << "new ";
    get_expression()->_get_subtype()->_publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE, ";
    get_expression()->_publish_cc();
    _cc_out << ")";
  }
  else {
    get_expression()->_publish_cc_state_object_init();
  }
  _cc_out << ")";
}


void 
IIRScram_OthersInitialization::_add_decl_into_cgen_symbol_table() {
  get_expression()->_add_decl_into_cgen_symbol_table();
}

void 
IIRScram_OthersInitialization::_publish_cc_state_object_init() {
  ASSERT(get_subtype() != NULL);
  _cc_out << " new ";
  if (get_subtype()->_is_kernel_type() == FALSE &&
      get_subtype()->_is_scalar_type() == TRUE){
    get_subtype()->_publish_cc_kernel_type();
  }
  else {
    get_subtype()->_publish_cc_type_name();
  }
  _cc_out << "(ObjectBase::VARIABLE";
  if(get_subtype()->_is_array_type() == TRUE && 
     get_subtype()->_is_anonymous()) {
    _cc_out << ", ";
    get_subtype()->_publish_cc_range();
  }
  _cc_out << ", ";
  if(get_subtype()->_is_array_type() == TRUE || 
     get_subtype()->_is_record_type() == TRUE) {
    if ((get_expression()->get_kind() == IIR_CONSTANT_DECLARATION) ||
	(get_expression()->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION)) {
      get_expression()->_publish_cc();
    } 
    else if(get_expression()->get_kind() == IIR_AGGREGATE) {
      get_expression()->_publish_cc_initialization_value();
    }
    else {
      get_expression()->_publish_cc_state_object_init();
    }
  } else {
    _cc_out << "(";
    get_subtype()->_publish_cc_kernel_type();
    _cc_out << ")";
    get_expression()->_publish_cc();
  }
  _cc_out << ")";
}

void 
IIRScram_OthersInitialization::_publish_cc() {
  get_subtype()->_publish_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE";
  _cc_out << ", ";
  if(get_subtype()->_is_array_type() == TRUE && 
     get_subtype()->_is_anonymous()) {
    get_subtype()->_publish_cc_range();
    _cc_out << ", ";
  }
  _publish_cc_initialization_value();
  _cc_out << ")";
}

void 
IIRScram_OthersInitialization::_get_list_of_input_signals(set<IIR_Declaration> *list) {
  ASSERT(get_expression() != NULL);
  get_expression()->_get_list_of_input_signals(list);
}

void 
IIRScram_OthersInitialization::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  ASSERT(get_expression() != NULL);
  get_expression()->_build_sensitivity_list(sensitivity_list);
}

ostream & 
IIRScram_OthersInitialization::_print( ostream &os ) {
  os << " others => ";
  ASSERT(get_expression() != NULL);
  os << *get_expression();
  
  return os;
}

set<IIR_TypeDefinition> *
IIRScram_OthersInitialization::_build_element_subtype_set( set<IIR_TypeDefinition> *context_set ){
  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;
  IIR_TypeDefinition *current = context_set->get_element();
  while( current != NULL ){
    if( current->_is_array_type() == TRUE ){
      retval->add( current->_get_element_subtype() );
    }
    else{
      // Then the context should be a subtype of an element's record.  We
      // have no way of checking that, so we have to assume it's right.
      retval->add( current );
    }
    current = context_set->get_next_element();
  }
  
  return retval;
}

IIR *
IIRScram_OthersInitialization::_semantic_transform( set<IIR_TypeDefinition> *context_set ){
  set<IIR_TypeDefinition> *element_types = _build_element_subtype_set( context_set );
  set_expression( get_expression()->_semantic_transform( element_types ) );
  delete element_types;

  return this;
}

void 
IIRScram_OthersInitialization::_type_check( set<IIR_TypeDefinition> *context_set ){
  set<IIR_TypeDefinition> *element_types = _build_element_subtype_set( context_set );
  get_expression()->_type_check( element_types );
  delete element_types;
}

IIR *
IIRScram_OthersInitialization::_rval_to_decl( IIR_TypeDefinition *new_type ){
  if( new_type->_is_array_type() == TRUE ){
    IIR_TypeDefinition *element_type = new_type->_get_element_subtype();
    // Everything else should have happened in type check.
    set_expression( get_expression()->_rval_to_decl( element_type ) );
    set_subtype( element_type );
  }
  else{
    set_expression( get_expression()->_rval_to_decl( new_type ) );
    set_subtype( new_type );
  }

  ASSERT( _is_resolved() == TRUE || parse_error == true );
  return this;
}


set<IIR_TypeDefinition> *
IIRScram_OthersInitialization::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  set<IIR_TypeDefinition> *retval = NULL;

  set<IIR_ArrayTypeDefinition> *array_types = _get_symbol_table()->get_in_scope_array_types();
  
  set<IIR_TypeDefinition> *actual_rvals = get_expression()->_get_rval_set();
  if( actual_rvals == NULL ){
    return NULL;
  }

  IIR_TypeDefinition *current_array_type; 
  current_array_type = array_types->get_element();
  while( current_array_type != NULL ){
   if( current_array_type->_get_element_subtype() != NULL ){
//      if( current_array_type->_get_element_subtype()->_get_declaration() != NULL ){
// 	cout << "element type: " 
// 	     << *current_array_type->_get_element_subtype()->_get_declaration()->get_declarator() 
// 	     << endl;
//      }
   }

    IIR_TypeDefinition *actual_type = actual_rvals->get_element();
    
    bool one_matched = false;
    while( actual_type != NULL ){
//       if( actual_type->_get_declaration() != NULL ){
// 	cout << "actual type: " << *actual_type->_get_declaration()->get_declarator() << endl;
//       }

      if( actual_type->_is_compatible( current_array_type->_get_element_subtype() ) != NULL ){
	one_matched = true;
      }
      actual_type = actual_rvals->get_next_element();
    }

    if( one_matched == true ){
      if( retval == NULL ){
	retval = new set<IIR_TypeDefinition>;
      }
      retval->add( current_array_type );
    }
	
    current_array_type = array_types->get_next_element();
  }


  return retval;
}

IIR_Boolean
IIRScram_OthersInitialization::_is_resolved(){
  ASSERT( get_expression() != NULL );

  return get_expression()->_is_resolved();
}

IIR_Boolean 
IIRScram_OthersInitialization::_is_globally_static(){
  ASSERT( get_expression() != NULL );

  return get_expression()->_is_globally_static();  
}
