#ifndef IIRSCRAM_OBJECT_DECLARATION_HH
#define IIRSCRAM_OBJECT_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ObjectDeclaration.hh,v 1.2 1999/03/09 20:55:42 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_ObjectDeclaration.hh"

class IIR_List;
class IIR_ObjectDeclaration;

class IIRScram_ObjectDeclaration : public IIRBase_ObjectDeclaration {

public:
  IIR_TypeDefinition *_get_subtype();
  IIR_TypeDefinition *_get_rval_pointed_at();

  IIR_Boolean _is_object();

  // This returns how many dimensions an array object has.. (0 if it's not
  // an array)
  IIR_Int32 _get_num_indexes();
  // If this is an array variable, get the type definition of the object
  // stored in the "nth" index...
  IIR_TypeDefinition *_get_type_of_element( int index );

  // This method is for objects that are instances of records, to find the
  // pieces within them...
  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  // Type check initializers and such...
  virtual void _type_check();

  // Make this virtual.  The only object declaration that doesn't have a
  // value is a file type declaration...
  virtual IIR *get_value() { return NULL; }

  virtual void set_value( IIR * ){
    _report_undefined_scram_fn("set_value()");
  }

  IIR_AttributeSpecificationList *_get_attribute_specification_list(){ return &attributes; }

  // Publish the arguments of the constructor of the
  // variable/signal/constant declaration.
  void _publish_cc_constructor_args();

  // Publish the type of the object, as required by the type constructor.
  virtual void _publish_cc_object_type();

  // Publish the object declaration with arguments to the constructor.
  void _publish_cc_decl_with_args();
  

  virtual void _publish_cc_type_name();
  void _publish_cc_universal_type();
  void _publish_cc_range();
  void _publish_cc_bounds();

  // This method is defined mainly for indexed names, but this definition
  // is the trivial case, and returns this.
  IIR_Declaration *_get_prefix_declaration() { return (IIR_Declaration*)this;}

  IIR_Boolean _is_scalar_type();
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_record_type();
  IIR_Boolean _is_access_type();

  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return TRUE; }
  const IIR_Char* _get_mangling_prefix();
  
  void _add_declarations_in_initializations();
  void _add_decl_into_cgen_symbol_table();
  void _clone(IIR_ObjectDeclaration*);

  virtual void _publish_vhdl_declarator_with_colon(ostream &);
  virtual void _publish_vhdl(ostream &);
  virtual void _publish_vhdl_subtype_indication(ostream &);
  virtual void _publish_vhdl_subtype_indication_with_expression(ostream &);
  virtual void _publish_vhdl_signal_kind(ostream &);
  virtual void _publish_vhdl_expression(ostream &);

  IIR_Declaration* _get_package_declaration() { return NULL; }
  
  virtual IIR_SignalKind _get_signal_kind();

  virtual IIR_Boolean _is_locally_static();
  virtual IIR_Boolean _is_globally_static();

protected:
  IIRScram_ObjectDeclaration() {}
  virtual ~IIRScram_ObjectDeclaration() = 0;
    
private:
};
#endif
