
#ifndef IIRSCRAM_CONCURRENT_GENERATE_FOR_STATEMENT_HH
#define IIRSCRAM_CONCURRENT_GENERATE_FOR_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConcurrentGenerateForStatement.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_ConcurrentGenerateForStatement.hh"

class IIR_List;

class IIRScram_ConcurrentGenerateForStatement : public IIRBase_ConcurrentGenerateForStatement {

public:

  void _publish_vhdl(ostream &);
  void _type_check();

  void _type_check_instantiate_statements();

  //  void _reopen_scope( symbol_table * );

  IIR_List *_get_statement_list(){ return &concurrent_statement_part; }

  //  void _publish_cc_binding_name(ostream& outstream = _cc_out);
  void _publish_cc_generate_elaborate();
  void _publish_cc();
  void _publish_cc_declarations();
  void _publish_cc_class();
  void _publish_cc_headerfile();
  void _publish_cc_elaborate();
  void _publish_cc_ccfile();
  void _publish_cc_headerfiles_for_cc();
  void _publish_cc_constructor();
  void _publish_cc_constructor_with_no_arguments();
  void _publish_cc_signal_objects_init(int);
  void _publish_cc_object_pointers_init();
  void _publish_cc_instantiate();
  void _publish_cc_createNetInfo();
  void _publish_cc_connect();
  void _publish_cc_getGenerateConstant();
  void _publish_cc_resetGenerateConstant();
  void _publish_cc_body_for_component_createNetInfo(IIR_ConcurrentStatement*);
  void _publish_cc_static_members();
  void _publish_cc_init(IIR *);
  void _publish_cc_universal_generate_range();
  void _publish_cc_generate_for_loop();
  void _publish_cc_generate_for_loop_with_zero(char *variable_name = "i");
  void _publish_cc_assign_to_loop_constant(const char * = "(int) i");

  IIR_DeclarationList* _get_declaration_list();
  
  IIR_Boolean _is_concurrent_generate_statement() { return TRUE; };

  IIR_Label *_find_instantiate_label( IIR_SimpleName * );

protected:
  
  IIRScram_ConcurrentGenerateForStatement() {};
  virtual ~IIRScram_ConcurrentGenerateForStatement() = 0;
    
private:
};

#endif
