#ifndef IIRSCRAM_HH
#define IIRSCRAM_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Ardhendu Singh asingh@ececs.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram.hh,v 1.6 1999/10/28 03:24:03 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include <iostream.h>
#include "IIRBase.hh"
#include "switch_file.hh"

#ifdef DEVELOPER_ASSERTIONS
extern switch_file _vhdl_out;  //file for vhdl output
extern switch_file _cc_out;    //file for c++ output
#endif

extern bool no_mangling;

class IIR;
class IIR_List;
template <class type> class set;
class IIR_Declaration;
class IIR_TypeDefinition;
class IIR_DesignatorList;
class IIR_Identifier;
class symbol_table;
class library_manager;
class IIR_TextLiteral;
class IIR_LibraryUnit;
class IIR_LibraryDeclaration;
class IIR_ArchitectureDeclaration;
class IIR_DeclarationList;
class IIR_DesignFile;
class IIR_ConcurrentStatement;
class IIR_Statement;
class IIR_AttributeSpecification;
class IIR_AttributeSpecificationList;
class IIR_FunctionDeclaration;
class IIR_AssociationList;
class IIR_Designator;
class IIR_EntityDeclaration;
class IIR_Label;
class IIR_PackageDeclaration;
class IIR_ConcurrentStatementList;
class IIR_ProcessStatement;
class IIR_GenericList;
class IIR_PortList;
class IIR_TypeDeclaration;
class IIR_IntegerLiteral;
class IIR_ConstantDeclaration;

class IIRScram : public IIRBase {

public:
  
#ifndef DEVELOPER_ASSERTIONS
  static switch_file _vhdl_out;  //file for vhdl output
  static switch_file _cc_out;    //file for c++ output
#endif

  /** VHDL publishing methods */
  //@{
  virtual void _publish_vhdl(ostream &);
  virtual void _publish_vhdl_range(ostream &);
  virtual void _publish_vhdl_decl(ostream &);
  virtual void _publish_vhdl_type_decl(ostream &);
  virtual void _publish_vhdl_subtype_decl(ostream &);
  virtual void _publish_vhdl_operator(ostream &);
  //@}

  /** C++ publishing methods */
  //@{
  virtual void _publish_cc();
  virtual void _publish_cc_init();
  virtual void _publish_cc_object_type();
  virtual void _publish_cc_wait_data();
  virtual void _publish_cc_data();
  virtual void _publish_cc_decl();
  virtual void _publish_cc_bounds();
  virtual void _publish_cc_range();
  virtual void _publish_cc_value();
  virtual void _publish_cc_universal_value();
  virtual void _publish_cc_binding_name(ostream& outstream = _cc_out);
  virtual void _publish_cc_subprogram_arg();
  virtual void _publish_cc_constructor_args();
  virtual void _publish_cc_sigdest();
  virtual void _publish_cc_declarator();
  virtual void _publish_cc_type_name();
  virtual void _publish_cc_for_index();
  virtual void _publish_cc_condition();
  virtual void _publish_cc_headers();

  // This is the default behaviour for _publish_cc_headerfiles_for_cc().
  // It has to be called explicitly.  It's defined here as both
  // declarations and statements call it.
  void _publish_cc_headerfiles_for_cc_default();

  virtual void _publish_cc_direction();

  //Works for only one case. These two functions need a lot of work
  virtual void _publish_cc_name_elaborate();
  virtual void _publish_cc_name();

  virtual void _publish_cc_state_object_init();
  virtual void _publish_cc_initialization_value();

  // This function specifies the type of object instatiated in
  // simulation kernel
  virtual void _publish_cc_universal_type();
  virtual void _publish_cc_kernel_type();

  // This function is implemented recursively in different nodes to handle
  // type conversion in procedure calls. The actual can be nest function
  // calls and the actual nested with them is extracted and published

  virtual void _publish_cc_first_objectParameter();
  virtual void _publish_cc_copy_generics_to_globals();

  //The following function is used for code generation that does runtime 
  //elaboration
  virtual void _publish_cc_elaborate();
  virtual void _publish_cc_addChild();
  void _publish_cc_prefix_string();
  virtual void _publish_cc_scoping_prefix(IIR *, IIR*, ostream& = _cc_out);

  //@}


  // get_declarator is required in a LOT of places.  The absence of
  // this virtual function results in a number of type casts.
  // I(Malolan) am commenting this function since this function name
  // clashes with the function name in the spec.  Instead adding the
  // same function with an unndersore in the front virtual
  // IIR_TextLiteral *get_declarator();
  virtual IIR_TextLiteral *_get_declarator();

  // These methods only apply to entities, components, etc.  (Or names
  // representing them, like resolved selected names, etc.)
  virtual IIR_GenericList *_get_generic_list();
  virtual IIR_PortList *_get_port_list();

  // This method has been introduced to remove unneccessary type castings
  virtual IIR* get_value();

  // This method returns any statement region found in the node.
  virtual IIR_List *_get_statement_list();

  // This method has been introduced to remove unneccessary type castings
  virtual IIR_Mode _get_mode();

  // This method tells use whether or not this is <name>.all
  virtual IIR_Boolean _is_by_all(){ return FALSE; }

  virtual IIR_Boolean _is_iir_declaration(){ return FALSE; }
  // This method tells us whether this node has been resolved or not.
  virtual IIR_Boolean _is_resolved(){ return FALSE; }

  virtual IIR_Boolean _is_literal(){ return FALSE; }

  // Does this node represent an "object".  (An object, according to the LRM, is
  // a constant, signal, variable, or a file.)
  virtual IIR_Boolean _is_object(){ return FALSE; }

  virtual IIR_Boolean _is_ascending_range();
  virtual IIR_Boolean _is_name(){ return FALSE; }
  virtual IIR_Boolean _is_signal(){ return FALSE; }
  virtual IIR_Boolean _is_resolved_signal(){ return FALSE; }
  virtual IIR_Boolean _is_variable(){ return FALSE; }
  virtual IIR_Boolean _is_constant(){ return FALSE; }
  virtual IIR_Boolean _is_text_literal(){ return FALSE; }
  virtual IIR_Boolean _is_type(){ return FALSE; }
  virtual IIR_Boolean _is_incomplete_type_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_subtype(){ return FALSE; }
  virtual IIR_Boolean _is_discrete_type(){ return FALSE; }
  virtual IIR_Boolean _is_scalar_type(){ return FALSE; }
  virtual IIR_Boolean _is_record_type(){ return FALSE; }
  virtual IIR_Boolean _is_array_type(){ return FALSE; }
  virtual IIR_Boolean _is_access_type(){ return FALSE; }
  virtual IIR_Boolean _is_integer_type(){ return FALSE; }
  virtual IIR_Boolean _is_floating_type(){ return FALSE; }
  virtual IIR_Boolean _is_character_type(){ return FALSE; }
  virtual IIR_Boolean _is_integer_literal(){ return FALSE; }
  virtual IIR_Boolean _is_floating_literal(){ return FALSE; }
  virtual IIR_Boolean _is_string_literal(){ return FALSE; }
  virtual IIR_Boolean _is_association(){ return FALSE; }
  virtual IIR_Boolean _is_sequential_signal_assignment(){ return FALSE; }
  virtual IIR_Boolean _is_concurrent_statement(){ return FALSE; }
  virtual IIR_Boolean _is_library_unit(){ return FALSE; }
  virtual IIR_Boolean _is_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_designator(){ return FALSE; }
  virtual IIR_Boolean _is_interface(){ return FALSE; }
  virtual IIR_Boolean _is_sequential_statement(){ return FALSE; }
  virtual IIR_Boolean _is_enumeration_type(){ return FALSE; }
  virtual IIR_Boolean _is_enumeration_literal(){ return FALSE; }
  virtual IIR_Boolean _is_subprogram(){ return FALSE; }
  virtual IIR_Boolean _is_statement(){ return FALSE; }
  virtual IIR_Boolean _is_numeric_literal();
  virtual IIR_Boolean _is_numeric_type(){ return FALSE; }
  virtual IIR_Boolean _is_physical_type(){ return FALSE; }
  virtual IIR_Boolean _is_attribute();
  virtual IIR_Boolean _is_static_expression() { return FALSE;}
  virtual IIR_Boolean _is_longest_static_prefix();
  virtual IIR_Boolean _is_aggregate_expression() { return FALSE; }
  virtual IIR_Boolean _is_composite_resolved_signal() { return FALSE; }
  virtual IIR_Boolean _is_textio();
  virtual IIR_Boolean _is_standard();
  virtual IIR_Boolean _is_relational_operator();
  virtual IIR_Boolean _is_primary_unit(){ return FALSE; }
  virtual IIR_Boolean _is_secondary_unit(){ return FALSE; }

  virtual IIR_Boolean _is_component_decl() { return FALSE; }
  virtual IIR_Boolean _is_entity_decl() { return FALSE; }
  virtual IIR_Boolean _is_configuration_decl() { return FALSE; }
  virtual IIR_Boolean _is_kernel_type() { return FALSE;}
  // Warning!!!!!!  It is not always right to typecast to
  // IIR_BlockStatement if this function returns true.  The reason being,
  // this will return true, if it is a block statement or if the label is
  // that of a block statement
  virtual IIR_Boolean _is_block_statement() { return FALSE;}

  // Warning!!!!!!  It is not always right to typecast to
  // IIR_ConcurrentGenerate*Statement if this function returns true.  The
  // reason being, this will return true, if it is a concurrent
  // generate*statement or if the label is that of a block statement
  virtual IIR_Boolean _is_concurrent_generate_statement() { return FALSE;}

  // _is_resolved_type : TRUE if the type defined contain resolution function
  virtual IIR_Boolean _is_resolved_type();

  // This returns TRUE, if the type definition, or subtype definition
  // is part of subtype declaration
  virtual IIR_Boolean _is_subtype_decl() { return FALSE; }

  virtual IIR_Boolean _is_operator() { return FALSE; }

  // If one of these methods returns TRUE, it is safe to cast to
  // that class.
  virtual IIR_Boolean _is_iir_configuration_item(){ return FALSE; }
  virtual IIR_Boolean _is_iir_entity_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_architecture_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_attribute_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_configuration_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_procedure_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_function_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_package_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_package_body_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_type_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_subtype_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_component_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_group_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_interface_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_element_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_physical_unit(){ return FALSE; }
  virtual IIR_Boolean _is_iir_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_record_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_floating_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_integer_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_access_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_scalar_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_enumeration_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_physical_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_array_type_definition(){ return FALSE; }
  virtual IIR_Boolean _is_iir_case_statement_alternative(){ return FALSE; }
  virtual IIR_Boolean _is_iir_label(){ return FALSE; }
  virtual IIR_Boolean _is_iir_subprogram_declaration(){ return FALSE; }
  virtual IIR_Boolean _is_iir_configuration_specification(){ return FALSE; }
  virtual IIR_Boolean _is_iir_attribute_specification(){ return FALSE; }
  virtual IIR_Boolean _is_iir_disconnect_specification(){ return FALSE; }
  virtual IIR_Boolean _is_iir_enumeration_literal(){ return FALSE; }
  virtual IIR_Boolean _is_iir_text_literal(){ return FALSE; }
  virtual IIR_Boolean _is_iir_name(){ return FALSE; }
  virtual IIR_Boolean _is_iir_statement(){ return FALSE; }
  virtual IIR_Boolean _is_iir_library_unit(){ return FALSE; }
  virtual IIR_Boolean _is_iir_library_declaration(){ return FALSE; }

  virtual IIR_Boolean _is_readable();
  virtual IIR_Boolean _is_writable();
  
  virtual void _set_passed_through_out_port(IIR_Boolean val);
  
  // These methods tell us whether an expression is locally (or globally
  // static) as defined by the LRM in section 7.4.1.  If
  // _is_locally_static() isn't overridden, then being a locally static
  // primary is sufficient to say we're locally static.  These methods also
  // apply to names, as the rules given in LRM section 6.1.  The to find
  // out if an IIR meets the criteria for a "static name", the method
  // "_is_globally_static" should be called where a name is appropriate.
  // To find out if an IIR meets the criteria for a "locally static name",
  // the method "_is_locally_static" should be called where a name is
  // appropriate.  Note too, that after resoultion simple names will be
  // replaced with their declaration...
  virtual IIR_Boolean _is_locally_static(){ return _is_locally_static_primary(); }
  virtual IIR_Boolean _is_globally_static(){ return _is_globally_static_primary(); }
  virtual IIR_Boolean _is_locally_static_primary();
  virtual IIR_Boolean _is_globally_static_primary();

  
#ifdef PROCESS_COMBINATION
  virtual void _static_elaborate(IIR_ArchitectureDeclaration*, 
				 IIR_DeclarationList*, char*);
#endif

  virtual IIR *_clone();
  void _clone(IIR*);

  virtual IIR  *_transmute();

  //  virtual void _get_list_of_input_signals(IIR_DesignatorList* list);
  virtual void _get_list_of_input_signals(set<IIR_Declaration>* list);
  virtual void _get_signal_source_info(set<IIR_Declaration>* siginfo);
  virtual IIR_AttributeSpecification *_get_attribute_specification(IIR*);

  virtual IIR_AttributeSpecificationList *_get_attribute_specification_list( );

  // Needed for guard signals
  virtual IIR_SignalKind _get_signal_kind();
  virtual IIR_Boolean _is_guard_signal();

  // This method returns the declaration of an indexed name.  If the
  // prefix is a declaration, returns it, or else, gets the declaration of
  // the prefix recursively.
  virtual IIR_Declaration* _get_prefix_declaration();

  //This is used on a selected name to get the package name in it
  virtual IIR_Declaration* _get_package_declaration();

  // The following function returns the type of the IIR_Name object that
  // is referred to
  virtual IIR_TypeDefinition* _get_name_type();

  //The following function is used for building the sensitivity list
  //while doing transmogrification
  virtual void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  // The following function is used to pick up the resolution function
  // for a subtype/type definition. This function is needed as all the
  // vhdl publishing is now done in scalar type.
  // This function is overloaded in the corresponding nodes that have
  // resolution function defined.

  virtual IIR_FunctionDeclaration *_get_resolution_function();
  virtual void _set_resolution_function(IIR_FunctionDeclaration *new_function );

  virtual IIR *_get_enclosing_scope();
  IIR_LibraryDeclaration *_get_work_library( );

  // These methods give derived classes a chance to generate implicit
  // declarations and so forth.
  virtual void _come_into_scope( symbol_table * ){}
  virtual void _come_out_of_scope( symbol_table * ){}

  // This function copies the identifiers declared in outer scope and accessed
  // somewhere within nested scope(s) to outer scopes till it reaches the
  // scope where the object was declared.
  
  void _copy_symbols_defined_in_enclosing_scope(symbol_table *current, symbol_table *outer);
  
  // The code generator needs to know what kind of unit is being
  // published.  This is acheived by the following static variable and the
  // corresponding wrapper methods.

  enum PublishedUnit {ENTITY_DECL, ARCHITECTURE_DECL, BLOCK, FUNCTION, 
		      PROCEDURE, PACKAGE, PACKAGE_BODY, PROCESS, PROCESS_STATE,
		      TYPE, GENERIC_MAP, GENERATE_FOR, GENERATE_IF,
		      DUMMY_ENTITY_DECL, CONFIGURATION_DECLARATION,
		      CASE_STATEMENT, NONE_PARSING, NONE}; 
  
  IIR_Char* _get_publish_prefix_string(void);
  void _set_publish_prefix_string(IIR_Char*);
  
  void _set_aggregate_iterator_subtype(IIR_TypeDefinition*);
  IIR_TypeDefinition* _get_aggregate_iterator_subtype();
  void _set_aggregate_iterator(int);
  int  _get_aggregate_iterator();
  
  void _set_currently_publishing_unit(PublishedUnit unit);
  PublishedUnit _get_currently_publishing_unit();
  
  void _set_current_process_statement(IIR_ProcessStatement* p_stmt);
  IIR_ProcessStatement* _get_current_process_statement();

  void _set_currently_publishing_vhdl_unit(PublishedUnit unit);
  PublishedUnit _get_currently_publishing_vhdl_unit();
  
  IIR_Boolean _is_currently_publishing_subprogram();
  IIR_Boolean _is_currently_publishing_generate_for();

  void _report_undefined_scram_fn(char *);

  // These methods have to do with semantic checks and such.
  
  // Symbol lookup methods are intended to be used on names. The
  // method accepting an argument essentially narrows the search to be
  // within the context of a set of declarations.  I.e. find the
  // "foo.bars" within the context of the declarations of "baz"es.
  virtual set<IIR_Declaration> *_symbol_lookup();
  virtual set<IIR_Declaration> *_symbol_lookup( IIR_Declaration *);
  virtual set<IIR_Declaration> *_symbol_lookup( set<IIR_Declaration> *);
  virtual set<IIR_Declaration> *_symbol_lookup(IIR_Boolean(IIR::*constraint_function)());

  
  IIR_Label *_lookup_label( IIR_Boolean complain_on_error );
  
  // These methods calculate a node's rval_set.  Either will return a
  // a set with a bunch of type definitions, or will return NULL if it
  // doesn't have a valid rval.  (Like for an undefined symbol, or a
  // library declaration or something).  The optional argument is a
  // method declared in IIR that returns a boolean value.  This method
  // will be called on declarations of things when being considered as
  // possbilities for symbols.  If the method returns false, the
  // declaration will not be considered as a possibility.  For
  // instance, if there is a type "FOO" in the current scope, and a
  // variable "FOO", and we're looking for the target of a variable
  // assignment statement, only the variable assignment will be
  // considered.
  virtual set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);

  virtual set<IIR_TypeDefinition> *_get_rval_set( set<IIR_TypeDefinition> *,
						  IIR_Boolean (IIR::*constraint_function)() = 0 );
  virtual set<IIR_TypeDefinition> *_get_rval_set( set<IIR_Declaration> *,
						  IIR_Boolean (IIR::*constraint_function)() = 0 );

  // This method takes the a set of return values that are context,
  // and a known return type, and returns the rval from the
  // context rvals that is correct.  For instance, if we have:
  // foo( 1 to  3 ).bar( 1 ) and we know the type of the whole expression,
  // and we have a set of types for foo( 1 to 3 ), this method will tell
  // us which is correct...
  virtual IIR_TypeDefinition *_determine_rval_in_set( set<IIR_TypeDefinition> *,
						      IIR_TypeDefinition * );

  // Same as previous method, but in cases like:
  // work.foo( 1 ), where the prefix has a declaration, but not a type...
  virtual IIR_Declaration *_determine_decl_in_set( set<IIR_Declaration> *,
						      IIR_TypeDefinition * );  

  //  virtual IIR_Declaration *_find_declarations( IIR_Declaration * );
  virtual IIR_Declaration *_find_in_implicit_list( char * );
  virtual set<IIR_Declaration> *_get_implicit_declarations( );
  virtual void _set_implicit_declarations( set<IIR_Declaration> * );


  // This method looks at this node as having been resolved as a formal in
  // an association, and returns the declaration associated with it.
  virtual IIR_Declaration *_find_formal_declaration();

  // This method should only be called on resolved "things".  For instance,
  // declarations, resolved names (indexed names with declaration prefixes,
  // etc.)
  virtual IIR_TypeDefinition *_get_subtype();

  // This method should only be called on resolved "things".  For instance,
  // declarations, resolved names (indexed names with declaration prefixes,
  // etc.)  It should only be called in objects that are access types (otherwise,
  // it returns NULL).
  virtual IIR_TypeDefinition *_get_rval_pointed_at(){ return NULL; }

  // This method calculates the locally static value of the expression it's
  // called on.  If this is impossible (i.e. the expression isn't static,
  // or it's not integer valued, it will return NULL.)  If possible, it
  // _allocates_ an IIR_IntegerLiteral with the result represented in it.
  virtual IIR_IntegerLiteral *_get_integer_static_value();
  
  // This method should only be called on resolved "things".  For instance,
  // declarations, resolved names (indexed names with declaration prefixes,
  // etc.)  Or, on type definitions.
  virtual IIR_TypeDefinition *_get_type_of_element( int );

  // This method returns the number of indexes an array object has.
  virtual IIR_Int32 _get_num_indexes( );

  // This method returns the type of an objects port in a particular position:
  // port( x : in bit; y : out integer; )  0 = bit typedefinition, 1 = integertypedefinition
  virtual IIR_TypeDefinition *_get_port_type( int );
  

  // Given our (resolved) r value, plus knowing what type of node we
  // are, transform ourselves into the correct declaration...
  virtual IIR *_rval_to_decl( IIR_TypeDefinition * );

  // Given a prefix of type (param 1), return the declaration for a suffix with
  // type (param 2)
  virtual IIR *_rval_to_decl( IIR_TypeDefinition *, IIR_TypeDefinition * );

  // Given a prefix declaration (param 1), return the declaration for a suffix with
  // type (param 2)
  virtual IIR *_rval_to_decl( IIR_Declaration *, IIR_TypeDefinition * );

  // This method takes a declaration, and returns a resolved IIR *
  // that has had the declaration applied to it.  For instance, a
  // IIR_SimpleName returns the declaration itself.  An IIR_SelectedName
  // resolves the prefix and the suffix, and returns itself.
  virtual IIR *_decl_to_decl( IIR_Declaration * );

  // This is the main call into the semantic processing routines.  
  // The set that gets passed in is the list of possible l-values
  // of the node being type-checked.
  virtual void _type_check( set<IIR_TypeDefinition> * );
  virtual void _type_check( IIR_TypeDefinition * );

  // The following methods are used to type check component configurations, and
  // configuration specifications.  Unfortunately, IIR is their closest direct
  // ancestor.
  void _type_check_configuration( IIR_AssociationList &port_map_aspect,
				  IIR_AssociationList &generic_map_aspect );
  
  // This method type checks the iteration scheme of IIR_ForLoopStatement
  // and IIR_ConcurrentGenerateForLoop statement.  Again, IIR is the closest
  // ancestor.  It takes the iteration scheme as param, and returns the correctly
  // resolved subtype for it.
  IIR_TypeDefinition *_type_check_iteration_scheme( IIR_ConstantDeclaration *iteration_scheme );

  virtual IIR *_get_component_name( );
  virtual void _set_component_name( IIR * );
  virtual IIR_LibraryUnit *_get_entity_aspect();

  // This virtual method allows semantic transformations to be made as
  // part of type_checking.  These transformations include things like
  // the conversion of indexed_names into function calls, and removing
  // some of the bizarreness that occurs in parsing.  The argument to
  // this function is the context that the node is seen in. (It's
  // possible rvalues).  Most nodes don't have transformations -
  // therefore the default behavior of this method, when not
  // overridden, is simply to return "this".
  // NOTE:  This method is intended to be called from _type_check
  // of the _containing_ node. I.e. this method is not intended to
  // be "recursively descending".
  virtual IIR *_semantic_transform( set<IIR_TypeDefinition> * );
  virtual IIR *_semantic_transform( IIR_TypeDefinition * );

  // The "print" method is intended to print out ONLY the raw data 
  // found in the IF.  This means it should not be made to print any
  // formatting or "labels", like "NAME: foo".  An exception might be
  // for lists that it would be alright to put commas between elements,
  // although I'm not sure why anyone would want to print a list in this
  // manner.  This method is NOT meant to be a way to publish VHDL source
  // code.  It is intended more for debuging and/or the generation of 
  // error messages.  Also, note that every overloaded _print method should
  // call the print method of it's direct decendent.
  virtual ostream &_print( ostream & );

  // This method, defined within the name class, IIR_Identifier class, and
  // IIR_Identifier class, converts a name into a string suitable for
  // use in a unix-type file system.
  virtual char *_convert_to_library_name();
  
  // This method gets the prefix of a name, and returns the string version
  // of it.
  virtual IIR_TextLiteral *_get_prefix_string();

  // This gets the symbol table of the parser that parsed this file.
  symbol_table *_get_symbol_table( );

  static void _set_library_manager( library_manager *l_m );
  static library_manager *_get_library_manager();
  
  // The following methods help to avoid publish the same signal attribute
  // multiple times.
  // Okay, these do not make sense here, but virtual functions are better
  // than having type casts in the code
  enum SignalAttribute {LAST_EVENT = 0, EVENT, ACTIVE, LAST_ACTIVE, LAST_VALUE,
			DRIVING, DRIVING_VALUE, QUIET, STABLE, TRANSACTION,
			INVALID};
  virtual IIR_Boolean _is_published_attribute_in_state(SignalAttribute);
  virtual void _add_published_attribute_in_state(SignalAttribute);
  virtual IIR_Boolean _is_published_attribute_in_constructor(SignalAttribute);
  virtual void _add_published_attribute_in_constructor(SignalAttribute);
  virtual IIR_Boolean _is_published_attribute_in_initstate(SignalAttribute);
  virtual void _add_published_attribute_in_initstate(SignalAttribute);

  // Sometimes a declaration that goes out of scope needs to have it's
  // interface made visible.  For instance, in
  // component_instantiation_statements, the interface of the entity,
  // component, or configuration instantiated needs to be visible at the
  // time of type checking.
  virtual void _make_interface_visible( symbol_table *add_declarations_into );
  virtual void _make_interface_visible( );

  IIR *_get_current_declarative_region();

  //The following function adds the constant declarations that
  //Initialize variables or signals into code generators symbol table
  virtual void _add_decl_into_cgen_symbol_table();

  IIR_Boolean _get_publish_object_without_prefix();
  void _set_publish_object_without_prefix(IIR_Boolean value);

  
  // This method will return precedence levels for any operator and literals. 
  // The precedence levels are given in the LRM.
  // There are 8 levels of precedence
  // level 8 are the integer literals and all function calls which return 
  // value. All others take precedence values according to LRM. The higher the
  // number , the higher the precedence.
  enum OperatorPrecedenceLevel {LOGICAL_OPERATOR, RELATIONAL_OPERATOR, SHIFT_OPERATOR,
				ADDING_OPERATOR, SIGN_OPERATOR, MULTIPLYING_OPERATOR,
				MISCELLANEOUS_OPERATOR, OTHERS};

  virtual OperatorPrecedenceLevel _get_operator_precedence();

  bool _get_mangling_flag();
  
  IIR_DesignFile *_get_design_file(){
    return _my_design_file;
  }

  void _set_design_file( IIR_DesignFile *new_design_file ){
    _my_design_file = new_design_file;
  }

  // This function copies the line number information from one node into another.  Probably
  // should be a static IIR:: function.
  static void copy_location ( IIRScram *source, IIRScram *dest );

  // This method copies the information passed into this node, and any nodes
  // instantiated directly in this one (should only be lists.
  virtual void _set_base_info( IIR_DesignFile *, int, int, int );

  // The following methods get called by the parser to hook specifications
  // to IIR nodes that need them.  For instance, if there is a variable
  // declaration foo and it has attribute bar, and in the VHDL exists
  // "attribute bar of foo is 7;", this attribute specification will be
  // attached to foo.  Similarly, disconnection specifications will be
  // attached to guarded signals as required.
  IIR_Boolean _attach_attribute_specification( IIR_AttributeSpecification * );
  IIR_Boolean _attach_disconnection_specification( IIR_AttributeSpecification * );

  virtual IIR_DeclarationList* _get_declaration_list();

  void _group_component_instantiations(IIR_ConcurrentStatementList* conc_stmt_list, int blockSize);
  
protected:
  IIRScram();
  virtual ~IIRScram() = 0;

  void _publish_cc_class_includes(IIR_ConcurrentStatementList* conc_stmt_list);
  void _publish_cc_signals(IIR_DeclarationList* decl_list);
  void _publish_cc_object_pointers(IIR_ConcurrentStatementList* conc_stmt_list);
  virtual void _publish_cc_object_pointers_init(IIR_ConcurrentStatementList* conc_stmt_list,
					IIR_DeclarationList* decl_list);
  void _publish_cc_destructor(IIR_ConcurrentStatementList* conc_stmt_list);

  void _publish_cc_anonymous_drivers(IIR_DeclarationList*);
  
#ifndef GLOBAL_DATA

  static IIR_Char *_current_publish_name;
  static IIR *_current_publish_node;
  static IIR_Char* _current_configuration_name;
  static IIR_Char* _current_architecture_name;
  static IIR_Char* _current_entity_name;
  static IIR_Char* _current_elab_name;
  static IIR_Int32 _number_of_processes;

  static IIR_Char* _current_package_name;
  static IIR_Char* _current_package_body_name;
  static IIR_Char* _current_another_name;

  // These two static variables were added to handle publishing of signals
  // of composite types.
  static IIR_Char *_current_suffix_name;
  
  // While Publishing Multidimensonal Arrays/Composite types, index level
  // has to be kept track of,across IF nodes and hence the following
  // declaration
  static IIR_Int32 _index_level;

  // This is a string that will be prepended to ALL declarations while
  // they are published.  This will help us in publishing different
  // perfixes in different contxts.  The wrapper methods for this variable
  // follow.
private:
  static IIR_Char* _publish_prefix_string;
  static IIR_TypeDefinition *_aggregate_iterator_subtype;
  static int _aggregate_iterator_counter;

  static PublishedUnit _currently_publishing_unit;
  static PublishedUnit _currently_publishing_vhdl_unit;


  //The following variable is set either true or false.  If the variable
  //is set true, the objects are published without the string
  //"state.current->" as prefix. This has been done to reduce The number
  //of functions to be written in all the nodes, one publishing with
  //"state.current->" as prefix and one without it.
  static IIR_Boolean _publish_object_without_prefix; 
  static IIR_ProcessStatement* _current_process_stmt;
public:
  // In case of resolution function and type conversion function
  // publishing, certain special handling is required for "return"
  // statements.  This static value is used to indicate that a possible
  // type conversion function or a resolution function is being published.
  static IIR_Boolean _allocate_return_value;

  static library_manager *libMgr;
#endif

    
};

inline 
ostream &
operator<<(ostream &os, IIRScram &is ){
  return is._print( os );
}
#ifdef GLOBAL_DATA
extern IIR_Char  *_current_publish_name;
extern IIR       *_current_publish_node;
extern IIR_Char  *_current_configuration_name;
extern IIR_Char  *_current_architecture_name;
extern IIR_Char  *_current_entity_name;
extern IIR_Char  *_current_elab_name;
extern IIR_Int32 _number_of_processes;
extern IIR_Char  *_current_package_name;
extern IIR_Char  *_current_package_body_name;
extern IIR_Char  *_current_suffix_name;
extern IIR_Int32 _index_level;
extern IIR_Boolean _allocate_return_value;
extern IIR_Char  *_current_another_name;

extern IIR_Char* _publish_prefix_string;
extern IIR_TypeDefinition *_aggregate_iterator_subtype;
extern int _aggregate_iterator_counter;
extern IIRScram::PublishedUnit _currently_publishing_unit;
extern IIRScram::PublishedUnit _currently_publishing_vhdl_unit;
extern library_manager *libMgr;
extern IIR_Boolean _publish_object_without_prefix; 
extern IIR_ProcessStatement* _current_process_stmt;
#endif
#endif

