/*$Id: io_error.cc,v 15.18 1999/10/30 08:04:59 al Exp $ -*- C++ -*-
 * Error handler.
 * Collection of functions to handle all types of errors
 * including user interrupts, system errors, overflow, etc.
 */
#include "u_opt.h"
#include "l_jmpbuf.h"
#include "io_error.h"
// testing=nonstrict
/*--------------------------------------------------------------------------*/
	void	error(int,const char*,...);
	void	error(int,const std::string&);
/*--------------------------------------------------------------------------*/
extern JMP_BUF env;
/*--------------------------------------------------------------------------*/
/* error: error message printer
 * print it, if severe enough
 * terminate command, if really bad
 */
void error(int badness, const char* fmt, ...)
{
  if (badness >= OPT::picky) {
    char buffer[BIGBUFLEN];
    va_list arg_ptr;
    va_start(arg_ptr,fmt);
    vsprintf(buffer,fmt,arg_ptr);
    va_end(arg_ptr);
    IO::error << buffer;
  }
  {if (badness >= bDISASTER){
    abort();
  }else if (badness >= bEXIT){
    exit(badness);
  }else if (badness >= bERROR){
    {if (ENV::run_mode == rBATCH){
      exit(badness);
    }else{
      siglongjmp(env.p,1);
      //throw badness;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
void error(int badness, const std::string& message)
{
  if (badness >= OPT::picky) {
    IO::error << message;
  }
  {if (badness >= bDISASTER){
    abort();
  }else if (badness >= bEXIT){
    exit(badness);
  }else if (badness >= bERROR){
    {if (ENV::run_mode == rBATCH){
      exit(badness);
    }else{
      siglongjmp(env.p,1);
      //throw badness;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
