/*$Id: d_mos123.h,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * MOS model - base for levels 1,2,3,6
 */
#ifndef D_MOS123_H
#define D_MOS123_H
#include "d_mos.h"
/*--------------------------------------------------------------------------*/
class MODEL_MOS123 : public MODEL_MOS_BASE {
  friend class MOS_COMMON;
protected:
  explicit MODEL_MOS123(const MODEL_MOS123&p):MODEL_MOS_BASE(p){unreachable();}
private:
  virtual void	parse_params(CS& cmd) = 0;
  virtual void	post_parse() = 0;
protected:
  void		parse_params_123(CS&);
  void		post_parse_123();
  void		print_123_begin(OMSTREAM,int)const;
  void		print_123_mid(OMSTREAM)const;
  void		print_123_end(OMSTREAM o)const {print_base_end(o);}
public:
  explicit MODEL_MOS123();
private: // override virtual
  void		parse(CS&);
  void		print(OMSTREAM,int)const = 0;
  void		tr_eval(COMPONENT*)const = 0;
protected:		/* input parameters */
  double   vto;		/* 1---c- zero-bias threshold voltage */
  double   kp;		/* -----b transconductance parameter (not 6) */
  double   gamma;	/* 1236c- bulk threshold parameter */
public:
  double   phi;		/* 1236cb surface potential */
protected:
  double   lambda;	/* 12-6c- channel-length modulation */
  double   tox;		/* ----c- oxide thickness */
  double   nsub;	/* -23-c- substrate doping */
  double   nss;		/* ----c- surface state density */
  double   xj;		/* -23--b metallurgical junction depth */
  double   ld;		/* --3--b lateral diffusion */
  double   uo;		/* -236c- surface mobility */
  double   delta;	/* --3--b width effect on threshold voltage */
  enum gate_t {gOPP = -1, gMETAL = 0, gSAME = 1};
  int	   tpg;		/* ----c- type of gate material - really gate_t */
public:
  int	   cmodel;	/* ----c- which capacitor model to use (2 or 3) */

protected:		/* calculated parameters */
  double   egap;
private:
  double   vfb;		/* ----c- flat-band voltage */
protected:
  double   vbi; 	/* -236-- "built-in" voltage (vfb + phi) */
  double   sqrt_phi;	/* 123-c- sqrt(phi) */
  double   phi_sqrt_phi;/* 123--- phi * sqrt(phi) or pow(phi,1.5) */
public:
  double   cox;		/* ---6cb oxide capacitance (E_OX / tox) */
private:
  struct {
    unsigned vto:1,	/* flags: set if the parameter has been */
	     kp:1,	/* calculated as opposed to entered, so */
	     gamma:1,	/* it will be re-calculated as needed.  */
	     phi:1;
  } calc;
  static int Count;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
