/*$Id: bm_tanh.cc,v 15.14 1999/10/20 08:53:59 al Exp $ -*- C++ -*-
 * behavioral modeling hyperbolic tangent
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_TANH::EVAL_BM_TANH(int c);
//		EVAL_BM_TANH::EVAL_BM_TANH(const EVAL_BM_TANH&);
//	void	EVAL_BM_TANH::parse(CS& cmd);
// 	void	EVAL_BM_TANH::print(int)const;
//	void	EVAL_BM_TANH::tr_eval(COMPONENT* d)const;
/*--------------------------------------------------------------------------*/
EVAL_BM_TANH::EVAL_BM_TANH(int c)
  :EVAL_BM_ACTION_BASE(c),
   _gain(NOT_INPUT),
   _limit(NOT_INPUT)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_TANH::EVAL_BM_TANH(const EVAL_BM_TANH& p)
  :EVAL_BM_ACTION_BASE(p),
   _gain(p._gain),
   _limit(p._limit)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_TANH::parse(CS& cmd)
{
  cmd.stuck();
  do{
    double gain=NOT_VALID;
    double limit=NOT_VALID;
    cmd >> gain >> limit;
    {if (cmd.gotit()){
      _gain  = gain;
      _limit = limit;
    }else{
      cmd.get("Gain",	&_gain);
      cmd.get("Limit",	&_limit);
      parse_base(cmd);
    }}
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_TANH::print(OMSTREAM where)const
{
  where << "  " << name()
	<< "  gain=" << _gain
	<< "  limit="<< _limit;
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_TANH::tr_eval(COMPONENT* d)const
{
  double x = ioffset(d->y0.x);
  double aa = x * _gain/_limit;
  double cosine = cosh(aa);
  double f1 = _gain / (cosine*cosine);
  double f0 = _limit * tanh(aa);
  d->y0 = FPOLY1(x, f0, f1);
  tr_final_adjust(&(d->y0));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
