#   ifndef	APP_IMAGE_H
#   define	APP_IMAGE_H

#   include	<bitmap.h>
#   include	<X11/Xlib.h>
#   include	<X11/Intrinsic.h>

#   include	<appColor.h>
#   include	<appFrame.h>

/************************************************************************/
/*									*/
/*  Used to store and manage a bitmap image.				*/
/*									*/
/************************************************************************/

typedef struct AppBitmapImage
    {
    BitmapDescription	abiBitmap;
    unsigned char *	abiBuffer;
    int			abiFormat;
    double		abiFactor;
    } AppBitmapImage;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int appImgMakeImage(	Display *		dis,
				int			screen,
				XImage **		pPimage,
				int			toWide,
				int			toHigh,
				AppColors *		ac,
				AppBitmapImage *	abi );

extern int appImgMakePixmap(	Display *			dis,
				int				screen,
				Window				win,
				GC				gc,
				Pixmap *			pPixmap,
				int				toWide,
				int				toHigh,
				AppColors *			ac,
				AppBitmapImage *		abi );

extern void appCleanBitmapImage(	AppBitmapImage *	abi );

extern void appInitBitmapImage( AppBitmapImage * abi );

extern int appImgMakeFileExtensions(	AppFileExtension **	pAfeList,
					int *			pAfeCount );

extern int appImgPastePixmap(		AppBitmapImage *	abi,
					double			pixelsPerTwip,
					Display *		display,
					Window			win,
					XSelectionEvent *	selEvent );

extern int appImgGetXvClipboard(	BitmapDescription *	bd,
					unsigned char **	pBuffer,
					Display *		display,
					int			screen );

extern int appImgPutXvClipboard(	const BitmapDescription *	bd,
					const unsigned char *		buffer,
					Display *			display,
					int				screen );
#   endif
