/************************************************************************/
/*									*/
/*  Definitions relating to rulers.					*/
/*									*/
/************************************************************************/

#   include	<appUnit.h>
#   include	"docBuf.h"

typedef void (*DragHair)( void * voided, int from, int to );

typedef struct ColumnSeparator
    {
    int		csX0;
    int		csX1;
    } ColumnSeparator;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void * tedMakeRuler(	int			height,
				double			horPixPerMM,
				double			magnification,
				Pixel			forePixel,
				Pixel			backPixel,
				Pixel			topPixel,
				Pixel			bottomPixel,

				int			leftRulerWidth,
				int			rightRulerWidth,
				int			docX0,
				int			docX1,

				int			minVisible,
				int			maxVisible,
				int			maximum,
				int			whatUnit );

extern void tedFreeRuler(	Display *	display,
				void *		voidtr );

extern void tedExposeHorizontalRuler(	Widget			w,
					void *			voidtr,
					XEvent *		event );

extern void tedScrollHorizontalRuler(	void *			voidtr,
					Widget			w,
					int			d	);

extern void tedSetHorizontalRulerRange(	void *		voidtr,
					Widget		w,
					int		docVisX0,
					int		docVisX1,
					int		docBackX1 );

extern void tedAdaptHorizontalRuler(	void *		voidtr,
					Widget		w,
					int		docX0,
					int		docX1,
					int		firstIndent,
					int		leftIndent,
					int		rightIndent,
					int		maximum,
					int		tabCount,
					TabStop *	tabStops,
					int		andExpose );

extern void     tedHorizontalRulerTrackMouse(	Widget		w,
						void *		voidtr,
						XEvent *	event,
						unsigned int *	pChanged,
						int *		pFirstIndent,
						int *		pLeftIndent,
						int *		pRightIndent,
						int *		pTabCount,
						TabStop **	pTabStops,
						int *		pCsCount,
						ColumnSeparator ** pCs,
						void *		voided,
						DragHair	dragHair );

extern void tedHorizontalRulerConfigure( Widget		w,
					void *			voidtr,
					XEvent *		event,
					Boolean *		pRefused );

extern int tedSetRulerColumns(	Widget			w,
				void *			voidtr,
				int			colX0,
				int			colX1,
				ColumnSeparator *	cs,
				int			csCount );
