/* -*- mode: C; mode: fold; -*- */
/* Copyright (c) 1992, 1998 John E. Davis
 * This file is part of JED editor library source.
 *
 * You may distribute this file under the terms the GNU General Public
 * License.  See the file COPYING for more information.
 */
/*{{{ Include Files */

#include "config.h"
#include "jed-feat.h"
#include <stdio.h>

#if defined(__unix__) || defined(VMS)

#include <errno.h>
#include <slang.h>

#include "jdmacros.h"

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#include <signal.h>
#if !defined(VMS) || (__VMS_VER >= 70000000)
# include <sys/types.h>
#endif

#include "sig.h"
#include "file.h"
#include "sysdep.h"
#include "misc.h"
#include "screen.h"
#include "cmds.h"
#include "hooks.h"

/*}}}*/


#if !defined(VMS) || (__VMS_VER >= 70000000)

static void sigwinch_handler (int sig) /*{{{*/
{
   sig = errno;
   Jed_Resize_Pending = 1;
# ifdef SIGWINCH
   SLsignal_intr (SIGWINCH, sigwinch_handler);
# endif
   errno = sig;
}

/*}}}*/
#endif

static volatile int Signal_In_Progress = 0;

#if !defined(VMS) || (__VMS_VER >= 70000000)
static void sig_exit_jed(int sig) /*{{{*/
{
   char buf[48];
   
   if (Signal_In_Progress)
     return;

   Signal_In_Progress = 1;
   SLsig_block_signals ();

   auto_save_all ();
   
   sprintf (buf, "Killed by signal %d.", sig);
   exit_error (buf, (sig == SIGSEGV) || (sig == SIGBUS));
   exit (1);
}

/*}}}*/

/* a control-G puts us here */
static void my_interrupt(int sig) /*{{{*/
{
   sig = errno;
   
   SLKeyBoard_Quit = 1;
   if (Ignore_User_Abort == 0) SLang_Error = USER_BREAK;
   SLsignal_intr (SIGINT, my_interrupt);

   errno = sig;
}

/*}}}*/

# if defined( SIGTSTP ) || (defined( VMS) && ( __VMS_VER >= 70000000))
int Signal_Sys_Spawn_Flag = 0;
/* This should only be called from outside disturbance */
void sig_sys_spawn_cmd(int sig) /*{{{*/
{
   sig = errno;
   
   Signal_Sys_Spawn_Flag = 1;
   sys_spawn_cmd();
   update(NULL, 1, 0, 0);		       /* force update */
   Signal_Sys_Spawn_Flag = 0;
   
   errno = sig;
}

/*}}}*/

# endif
#endif /* NOT VMS */

#ifdef SIGTTIN
static void background_read (int sig) /*{{{*/
{
   sig = errno;
   if (Stdin_Is_TTY == 0) 
     {
	if (Signal_In_Progress)
	  return;

	Signal_In_Progress = 1;
	SLsig_block_signals ();
	exit_error ("Attempt to read from background-- exiting.", 0);
	exit (1);
     }
   sig_sys_spawn_cmd (0);
   errno = sig;
}

/*}}}*/
#endif

void init_signals (void) /*{{{*/
{
#if !defined(VMS) || (__VMS_VER >= 70000000)
   
#ifdef SIGWINCH
   (void) SLsignal_intr(SIGWINCH, sigwinch_handler);
#endif

   SLsignal_intr (SIGINT, my_interrupt);
   SLsignal (SIGHUP, sig_exit_jed);
   SLsignal (SIGQUIT, sig_exit_jed);
   SLsignal (SIGILL, sig_exit_jed);
   SLsignal (SIGTRAP, sig_exit_jed);
#if 0
   SLsignal (SIGIOT, sig_exit_jed);  /* used by abort */
#endif
#ifdef SIGPIPE
   SLsignal_intr (SIGPIPE, SIG_IGN);
#endif
   /* SIGNAL (SIGFPE, sig_exit_jed); */
#ifdef SIGBUS
   SLsignal (SIGBUS, sig_exit_jed);
#endif
#if 0
   SLsignal (SIGSEGV, sig_exit_jed);
#endif
#ifdef SIGSYS
    SLsignal (SIGSYS, sig_exit_jed);
#endif
    SLsignal (SIGTERM, sig_exit_jed);
   
#ifdef SIGTSTP
   if (SIG_DFL != SLsignal_intr (SIGTSTP, sig_sys_spawn_cmd))
     Jed_Suspension_Not_Allowed = 1;
#endif

#ifdef SIGTTOU
   SLsignal_intr (SIGTTOU, background_read);
#endif
#ifdef SIGTTIN
   SLsignal_intr (SIGTTIN, background_read);
#endif
#endif /* VMS */
}

/*}}}*/

#endif				       /* __unix__ || VMS */
