/* Copyright (c) 1992, 1998 John E. Davis
 * This file is part of JED editor library source.
 *
 * You may distribute this file under the terms the GNU General Public
 * License.  See the file COPYING for more information.
 */

#include "config.h"
#include "jed-feat.h"

#include <stdio.h>
#include <slang.h>

#include "jdmacros.h"

#include "display.h"
#include "hooks.h"

void (*tt_beep)(void)  			= SLtt_beep;
void (*tt_write_string)(char *)  	= SLtt_write_string;
void (*tt_get_terminfo)(void)  		= SLtt_get_terminfo;
void (*tt_set_color)(int, char *, char *, char *) = SLtt_set_color;
void (*tt_set_mono) (int, char *, SLtt_Char_Type) = SLtt_set_mono;

#ifndef IBMPC_SYSTEM
void (*tt_set_color_esc)(int, char *)	= SLtt_set_color_esc;
void (*tt_wide_width)(void)  		= SLtt_wide_width;
void (*tt_narrow_width)(void)  		= SLtt_narrow_width;
void (*tt_enable_cursor_keys)(void)  	= SLtt_enable_cursor_keys;
void (*tt_set_term_vtxxx)(int *)  	= SLtt_set_term_vtxxx;
#endif

int *tt_Ignore_Beep  		= &SLtt_Ignore_Beep;
int *tt_Use_Ansi_Colors  	= &SLtt_Use_Ansi_Colors;
int *tt_Term_Cannot_Scroll  	= &SLtt_Term_Cannot_Scroll;
int *tt_Term_Cannot_Insert  	= &SLtt_Term_Cannot_Insert;
#ifndef IBMPC_SYSTEM
int *tt_Blink_Mode		= &SLtt_Blink_Mode;
/* int *tt_Baud_Rate  		= &SLtt_Baud_Rate; */
#endif

/* a hook to parse some command line args. */
int (*X_Argc_Argv_Hook)(int, char **);


void flush_output (void)
{
   SLtt_flush_output ();
}

static void get_screen_size (int *r, int *c)
{
   SLtt_get_screen_size ();
   *r = SLtt_Screen_Rows;
   *c = SLtt_Screen_Cols;
}

void (*tt_get_screen_size)(int *, int *) = get_screen_size;

   
