% This file should not be byte-compiled.
% It is loaded from site.sl and permits various flavors of jed to share the
% same set of S-Lang files. It is written in RPN for efficiency.
#ifdef MSWINDOWS XWINDOWS MOUSE
. "mouse" evalfile pop
#endif

#ifdef WINGUI
. 4 2 mouse_map_buttons	       %  map Right to Middle
. 2 4 mouse_map_buttons	       %  map Middle to Right
. 0 enable_top_status_line
. "wmenu.sl" evalfile pop
. simple_menu
#elifexists menu_create_menu_bar
. "menus" evalfile pop
#endif

#ifnexists menu_create_menu_bar
define menu_create_menu_bar () { _pop_n (_NARGS); }
define menu_append_item () { _pop_n (_NARGS); }
define menu_append_separator () { _pop_n (_NARGS); }
define menu_append_popup () { _pop_n (_NARGS); }
define menu_use_menu_bar () { _pop_n (_NARGS); }
#endif

#ifnexists enable_menu_keys
define enable_menu_keys ();
#endif

#ifdef XWINDOWS
. "HOST" getenv =$1
% . $1 NULL != { "XJed@" $1 strcat x_set_window_name } if
. "skip_word" 		"^[[c" setkey      %/* shift-right */
. "bskip_word"		"^[[d" setkey      %/* shift-left */
. "goto_top_of_window"	"^[[a" setkey      %/* shift-up */
. "goto_bottom_of_window"	"^[[b" setkey      %/* shift-down */
. "beg_of_line"		"\e[1~" setkey		% Home
. "eol_cmd"		"\e[4~" setkey		% End
#endif

#ifndef OS2 UNIX WIN32
autoload ("run_shell_cmd",		"shell");
#endif
% For compatability
define shell_cmd ()
{
   () = run_shell_cmd ();
}


define goto_visible_eol ()
{
#ifdef HAS_LINE_ATTR
   if (down_1 ())
     {
	if (is_line_hidden ())
	  skip_hidden_lines_forward (1);
	go_left_1 ();
     }
#endif
   eol ();
}

define mark_to_visible_eol ()
{
   push_mark ();
   goto_visible_eol ();
}

define transpose_lines ()
{
   bol (); push_mark ();
#ifdef HAS_LINE_ATTR
   mark_to_visible_eol ();
   bufsubstr ();		       %  on stack
   go_right_1 ();
   del_region();
   skip_hidden_lines_backward (1);
   bol();
   insert(());
   newline();
   skip_hidden_lines_forward (1);      %  goes to bol
#else
   line_as_string ();                  %  on stack
   go_right_1 ();
   del_region();
   go_up_1 (); bol();
   insert(());
   newline();
   go_down_1 ();                               %  goes to bol
#endif
}

#ifdef HAS_LINE_ATTR
autoload ("folding_mode", "folding");
add_completion ("folding_mode");

variable Fold_Mode_Ok = 0;
define fold_mode ()
{
   if (Fold_Mode_Ok) folding_mode ();
}

#endif

#ifdef HAS_BLOCAL_VAR
define define_blocal_var (name, value)
{
   create_blocal_var (name);
   set_blocal_var (value, name);
}
#endif

#ifdef HAS_DFA_SYNTAX
set_highlight_cache_dir (extract_element(get_jed_library_path (), 0, ','));
#else
% dummy functions that enable jed to work in mixed environments
define enable_highlight_cache (x, y);
define define_highlight_rule (x,y,z);
define build_highlight_table (x);
#endif

#ifdef WIN32 
MSDOS_Has_Long_File_Names = 1;
variable W32shell_Perform_Globbing = 0;
define _win32_get_helper_app_name ()
{
   variable s, h;

   s = getenv ("COMSPEC");
   if (s == NULL)
     s = "cmd.exe";
   if (W32shell_Perform_Globbing)
     h = dircat (Jed_Bin_Dir, "w32/g32shell.exe");
   else
     h = dircat (Jed_Bin_Dir, "w32/w32shell.exe");

   sprintf ("%s %s /c", h, s);
}
#else
# ifdef MSDOS
#  ifdef 16_BIT_SYSTEM
MSDOS_Has_Long_File_Names = 0;
#  else
$1 = getenv ("LFN");
if ($1 == NULL) $1 = "N";
MSDOS_Has_Long_File_Names = ("Y" == strup ($1));
#  endif
# endif
#endif
