/* coollocal.h  - header for internel usage
   Copyright (C) 1996, 1997 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#ifndef COOLLOCAL_H
#define COOLLOCAL_H

/* Various rendering routines called internally */
void render_bevel (Window win, int x1, int y1, int x2, int y2, int thick, int sunken);
long render_textbox (CWidget * w, int redrawall);
void render_bitmap_button (CWidget * w, int state);
void render_bw_image (CWidget * w, int x, int y, int rendw, int rendh);

/* used internally to process filebrowser events */
char *handle_browser (const char *identifier, CEvent * cwevent, int options);

void render_button (CWidget * w);
void render_textinput (CWidget * w);
void render_window (CWidget * w);
void render_bar (CWidget * w);
void render_text (CWidget * w);
void render_status (CWidget * w, int expose);
void render_scrollbar (CWidget * w);
void render_sunken (CWidget * w);
int which_scrollbar_button (int bx, int by, CWidget * w);
long count_textbox_lines (CWidget * w, int all);
void render_progress (CWidget * w);
void render_switch (CWidget * w);
int (*default_event_handler (int kindofwidget)) (CWidget *, XEvent *, CEvent *);
CWidget **find_empty_widget_entry (void);
CWidget *allocate_widget (Window newwin,
			  const char *ident, Window parent, int x, int y,
			  int width, int height, int kindofwidget);
int eh_picture (struct cool_widget *w, XEvent * xevent, CEvent * cwevent);
void drawstring_xy (Window win, int x, int y, const char *text);
void drawstring_xy_hotkey (Window win, int x, int y, const char *text, int hotkey);
int run_callbacks (CWidget * w, XEvent * xevent, CEvent * cwevent);
void process_external_focus (Window win, int type);
void focus_window (Window win);
void link_scrollbar_to_textbox (CWidget * w, CWidget * textbox, XEvent * xevent, CEvent * cwevent, int whichscrbutton);
void link_scrollbar_to_editor (CWidget * w, CWidget * editor, XEvent * xevent, CEvent * cwevent, int whichscrbutton);
void destroy_picture (CWidget * w);
int edit_translate_key (unsigned int x_keycode, long x_key, int x_state, int *cmd, int *ch);
Window draw_file_browser (const char *identifier, Window parent, int x, int y,
		   const char *dir, const char *file, const char *label);
void toggle_cursor (void);

/* returns non-zero if they keysym of one of the control keys (shift, capslock etc.) */
int mod_type_key (KeySym x);

Window my_XmuClientWindow (Display * dpy, Window win);

/* initialise drag and drop */
void initialise_drag_n_drop (void);
void render_focus_border (Window win);

void toggle_radio_button (CWidget * w);
char *whereis_hotchar (const char *labl, int hotkey);
int match_hotkey (KeySym a, KeySym b);
int find_hotkey (CWidget * w);
int find_letter_at_word_start (unsigned char *label, unsigned char *used_keys, int n);

void set_font_tab_width (int t);
int get_font_tab_width (void);

void destroy_focus_border (void);
void create_focus_border (CWidget * w, int border);

typedef unsigned int cache_type;

void edit_draw_proportional (void *data,
	   void (*converttext) (void *, long, cache_type *, int, int, int),
	   int calctextpos (void *, long, long *, int),
				int scroll_right,
				Window win,
				int x_max,
				long b,
				int row,
				int y,
				int x_offset,
				int tabwidth);


#endif				/* ! COOLLOCAL_H */

