/* 
-----------------------------------------
lexer.l : analizzatore lessicale per g48
Copyright (C) by M. Andreoli
-----------------------------------------
*/

%{
#include "y.tab.h"
#include "version.h"

#ifndef YYSTYPE
#define YYSTYPE char *
#endif

static char *token; 

%}

/*
 * dichiarative flex
 *----------------------
 */

ws		[ \t\n]+
string		\"[^"]*\"
quoted		\'[^']*\'
rpn		\`[^`]*\`
rpnprg		\\<<(.)*\\>>	
alpha		[A-Za-z\\\$\._]
escape		(\\->)|(\\<-)|(\\\.)
dig		[0-9]
num1		[#]?{dig}+\.?([eE][-+]?{dig}+)?
num2		[#]?{dig}*\.{dig}+([eE][-+]?{dig}+)?
number		{num1}|{num2}	
name		({escape}|{alpha}|{dig})+
c-comment	"/*"([^/])*"/" 
hp-comment	\@(.*)\n
unix-comment	^\#(.*)\n
comment		{c-comment}|{hp-comment}
c-type		void|unsigned|short|int|char|float|long|double|register|typedef|static|extern|struct|union

/* 
 * riconoscimento token 
 * --------------------
 */

%%
		/* elementi scartati */
{comment}
{unix-comment}
{ws}		
		/* elementi lessicali di base */

{c-type}	yyset("c-type"); 	return(TYPE);
{string}	yyset("string"); 	return(STRING);
{rpn}		yyset("rpn"); 		return(RPN);
{rpnprg}	yyset("rpnprg"); 	return(RPNPRG);
{number}	yyset("number"); 	return(NUMBER);
{quoted}	yyset("quoted"); 	return(QUOTED);

		/* costrutti del C */

if		yyset("if");     	return(IF);
else		yyset("else");   	return(ELSE);
for		yyset("for");    	return(FOR);
while		yyset("while");    	return(WHILE);
switch		yyset("switch");    	return(SWITCH);
case		yyset("case");    	return(CASE);
default/\:	yyset("default");    	return(DEFAULT);
{name}		yyset("name");   	return(NAME);

		
		/* operatori C che non necessitano di traduzione 
		e in genere singoli caratteri */

.		yyset("unk");	 	return(yytext[0]);

%%


int yyset(char *m)
{

token=(char *) malloc( strlen(yytext)+1);
memcpy((char *) token,yytext,strlen(yytext)+1);

#ifdef DEBUG
yymsg(m);
#else
yylval=(YYSTYPE) token;
#endif

}


int yymsg( char *m)
{
printf("\t%s: (%s)\n",m,token);
}

#ifdef DEBUG

int main()
{
while (1) yylex();
}
#endif
