#---------------------------------------------------------------
# The smileys
#---------------------------------------------------------------

# Maximum number of smileys allowed.  The range of speedhappy is thus
# -MaxSmileys+1 .. MaxSmileys (0 means one frowning face)
set MaxSmileys 5
# Number of speed smileys currently displayed.  Positive means
# they are smiling; 0 or negative means they are frowning :)
set speedhappy 1
# Number of mistake smileys currently displayed.
set mistakehappy 1

frame .status.smileys
frame .status.smileys.speed
frame .status.smileys.mistakes
pack .status.smileys.speed .status.smileys.mistakes -side top -anchor w
pack .status.smileys -side left -anchor w
for {set i 0} {$i < $MaxSmileys} {incr i} {
    label .status.smileys.speed.smiley$i -bitmap @bit_smiley.h
    label .status.smileys.speed.saddy$i -bitmap @bit_saddy.h
    label .status.smileys.mistakes.smiley$i -bitmap @bit_smiley.h
    label .status.smileys.mistakes.saddy$i -bitmap @bit_saddy.h
}

pack .status.smileys.speed.smiley0 -side left -anchor w
pack .status.smileys.mistakes.smiley0 -side left -anchor w

#---------------------------------------------------------------
# Procedure: adjustsmileys {w old new}
#  Put $new smileys in widget $w.  There were $old before.
#  Note that zero or negative values for $new and $old means
#   frowning faces instead of smiling faces.
#---------------------------------------------------------------
proc adjustsmileys {w old new} {
    if {$old < $new} {
	while {$old < $new} {
	    if {$old <= 0} {
		pack forget $w.saddy[expr -$old]
	    }
	    if {$old >= 0} {
		pack $w.smiley$old -side left -anchor w
	    }
	    incr old
	}
    } elseif {$old > $new} {
	while {$old > $new} {
	    incr old -1
	    if {$old >= 0} {
		pack forget $w.smiley$old
	    }
	    if {$old <= 0} {
		pack $w.saddy[expr -$old] -side left -anchor w
	    }
	}
    }
}
