/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: trdrain_mpi.c,v 1.3 1999/11/08 06:20:37 bbarrett Exp $
 *
 *	Function:	- unloads trace data for one MPI world
 *	Accepts:	- trace file desc. opened for append
 *			- GPS array of world
 *			- GPS array length
 *			- get/forget flag
 *			- delay period in secs after flush signal
 */

#include <unistd.h>

#include <lam_ksignal.h>
#include <app_mgmt.h>
#include <mpitrace.h>
#include <preq.h>
#include <trreq.h>
#include <typical.h>

int
trdrain_mpi(fd, world, nworld, keep, flush_delay)

int   			fd;    
struct _gps		*world;
int			nworld;
int			keep;
int			flush_delay;

{
	int		i;
	int		(*drain)();

	drain = keep ? lam_rtrfget : lam_rtrfforget;
/*
 * Signal everybody to flush in-process trace buffers to the daemon.
 */
	if (flush_delay >= 0) {

		for (i = 0; i < nworld; i++) {
			rpdoom(world[i].gps_node, SELECT_PID,
					world[i].gps_pid, LAM_SIGTRACE);
		}

		if (flush_delay > 0) {
			sleep((unsigned) flush_delay);
		}
	}
/*
 * Drain the init/on/off traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRONOFF, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}
/*
 * Drain the communicator traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRCOMM, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}
/*
 * Drain the datatype traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRDTYPE, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}
/*
 * Drain the runtime traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRRUNTIME, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}

	return(0);
}
