/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: set.c,v 1.10 1998/01/05 01:18:45 tiggr Exp $  */

#include <string.h>
#include "trt.h"
#include <tom/tom-r.h>
#include "keyed.h"

tom_object
i_tom_Set_r_at_r (tom_object self, selector cmd, tom_object key)
{
  set_elt *be = (void *) bucket_elt_find (self, key);

  return be ? be->c.key : 0;
}

tom_object
i_tom_EqSet_r_at_r (tom_object self, selector cmd, tom_object key)
{
  set_elt *be = (void *) bucket_elt_find_eq (self, key);

  return be ? be->c.key : 0;
}

static void
mark_container_elts (tom_object self)
{
  struct _es_i_tom_HashTable *ht = trt_ext_address (self, _ei_i_tom_HashTable);
  set_elt **pbe, **buckets = ht->buckets;
  tom_int i, n = ht->num_buckets;
  void *nbe;

  for (i = 0; i < n; i++)
    for (pbe = nbe = &buckets[i]; *pbe; pbe = nbe)
      {
	if (TGC_COLOUR ((*pbe)->c.key->asi) == TGC_WHITE)
	  {
	    set_elt *be = *pbe;

	    *pbe = be->c.next;
	    xfree (be);

	    ht->length--;
	  }
	else
	  nbe = &(*pbe)->c.next;
      }
}

void
i_tom_MutableSet_v_gc_container_mark_elements (tom_object self, selector cmd)
{
  mark_container_elts (self);
}

void
i_tom_MutableEqSet_v_gc_container_mark_elements (tom_object self, selector cmd)
{
  mark_container_elts (self);
}

void
i_tom_MutableSet_v_add_r (tom_object self, selector cmd, tom_object object)
{
  bucket_elt_find_create (self, object, sizeof (set_elt));
}

void
i_tom_MutableEqSet_v_add_r (tom_object self, selector cmd, tom_object object)
{
  bucket_elt_find_create_eq (self, object, sizeof (set_elt));
}

void
i_tom_MutableSet_v_remove_r (tom_object self, selector cmd, tom_object object)
{
  bucket_elt *be = bucket_elt_remove (self, object);

  xfree (be);
}

void
i_tom_MutableEqSet_v_remove_r (tom_object self, selector cmd, tom_object object)
{
  bucket_elt *be = bucket_elt_remove_eq (self, object);

  xfree (be);
}

tom_object
i_tom_MutableEqSet_r_retrieve (tom_object self, selector cmd)
{
  bucket_elt *be = bucket_elt_retrieve (self);
  tom_object ret = be->key;

  xfree (be);
  return ret;
}
