/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1997 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMVarRef.m,v 1.4 1998/01/05 01:14:09 tiggr Exp $  */

#define OTMVARREF_DECLARE_PRIVATE_METHODS
#import "OTMVarRef.h"
#import "OTMArgument.h"
#import "OTMCustomMethod.h"
#import "OTMType.h"
#import "global.h"

@implementation OTMVarRef

+(OTMVarRef *) referenceToVariable: (OTMVariable *) v
{
  return [[self gcAlloc] initWithVariable: v];
}

-(void) gcReference
{
  MARK (var);
  [super gcReference];
}

-(id) initWithVariable: (OTMVariable *) v
{
  var = v;

  return [super initWithType: [v type]];
}

/********** forwarding **********/

-(BOOL) argumentp
{
  return [var argumentp];
}

-(BOOL) checkProperArgument: (OTMMethod *) m
{
  return [var checkProperArgument: m];
}

-(void) compileAddressListWithFirst: (id <TLString>) f
			  separator: (id <TLString>) s
{
  return [var compileAddressListWithFirst: f separator: s];
}

-(void) compileAssignment: (OTMExpr *) rhs
{
  [var compileAssignment: rhs];
}

-(id) conditionCopyFor: (OTMCustomMethod *) method
{
  if ([var argumentp])
    {
      OTMArgument *a = [method argumentNumbered:
			[(OTMArgument *) var argumentNumber]];

      if (a)
	return [isa referenceToVariable: a];
    }
  return self;
}

-(OTMExpr *) lhsInvalid
{
  return [var lhsInvalid];
}

-(id <TLString>) variableName
{
  return [var variableName];
}

-(id) outputDeclaration: (id) stream;
{
  return [var outputDeclaration: stream];
}

-(id <TLString>) outputName
{
  return [var outputName];
}

-(id) outputReference
{
  return [var outputReference];
}

-(id) precompile
{
  return [var precompile];
}

-(BOOL) residesInRefStruct
{
  return [var residesInRefStruct];
}

-(id <TLString>) result
{
  return [var result];
}

@end
