/* Unresolved invocation.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMUnvocation.h,v 1.8 1998/01/05 01:14:01 tiggr Exp $  */

#import "OTMExpr.h"

@class OTMMethod;

@interface OTMUnvocation: OTMExpr
{
  /* The known name parts of the method being invoked.  */
  TLVector *name_parts;

  /* The receiver.  */
  OTMExpr *receiver;

  /* The sender.  */
  OTMMeta *sender;

  /* The arguments.  */
  TLVector *arguments;

  /* Methods that are still a candidate for invocation.  */
  id eligible_methods;

  /* The possible argument types, based on the argument types of the
     eligible_methods.  */
  TLVector *possible_arg_types;

  /* Iff SUPER_P, this can be the super to which the search is to be
     confined.  */
  OTMMeta *confined;

  /* Iff !0, we're only to consider superclasss of the receiver.  */
  unsigned int super_p: 1;
}

+(OTMUnvocation *) unvocationWithReceiver: (OTMExpr *) rcv
				   sender: (OTMMeta *) snd
				arguments: (TLVector *) args
			        nameParts: (TLVector *) v
				    super: (BOOL) super_p
				 confined: (OTMMeta *) confined;

#ifdef OTMUNVOCATION_DECLARE_PRIVATE_METHODS

-(id) initWithReceiver: (OTMExpr *) rcv
		sender: (OTMMeta *) snd
	     arguments: (TLVector *) args
	     nameParts: (TLVector *) v
		 super: (BOOL) super_p
	      confined: (OTMMeta *) confined;

#endif

@end
