/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMTop.h,v 1.27 1998/01/05 01:13:52 tiggr Exp $  */

#import "global.h"

@class OTMType;

@interface OTMTop: TLObject
{
  /* The file in which this thing was declared.  */
  id <TLString> filename;

  /* The linenumber in said file.  */
  int line_number;

  /* Declaration qualifiers.  */
  otm_qualifiers qualifiers;

  /* Declaration informatio.  */
  unsigned int defined, declared;
}

/* Designated initializers.  The default `-init' initializes the instance
   variables from the global information provided by the parser.  */
-initWithLine: (int) line inFile: (id <TLString>) name;
-init;

/* Return the actual self for the receiving type, in the CONTEXT.  */
-(id) actualSelf: (id) context;

/* Return the actual self for the receiving type, in the CONTEXT, without
   resolving posing.  */
-(id) actualSelfNonPosing: (id) context;

/* Return YES for constants.  */
-(BOOL) constantp;

-(void) description: (id <TLMutableStream>) outarg;

/* Output a `# n fff' line directive for this object.  */
-(void) outputLineDirective;

/* Return what needs to be output for a new line.  */
-(id <TLString>) nl;

/* Return what needs to be output for a new line, but do not emit a line
   directive.  */
-(id <TLString>) nlPlain;

/* Elaborate the receiving object and return the result.  */
-(id) elaborate;

/* Get the declared information.  */
-(id <TLString>) filename;
-(int) line;

/* Update declared information.  */
-(void) refreshLocation;

/* Get declared information from the OTHER, and return SELF.  */
-(id) getLocationFrom: (OTMTop *) other;

/* Set the line.  */
-(void) setLine: (int) line;

/* Patch any remains due to interface file reading order.  Return
   replacement.  */
-(id) resolveInContext: (OTMMeta *) current;

-(otm_qualifiers) qualifiers;
-(void) setQualifiers: (otm_qualifiers) q;

-(BOOL) declaredp;
-(void) setDeclared: (BOOL) ynp;

-(BOOL) declarationOutputp;
-(void) setDeclarationOutputP: (BOOL) ynp;

-(BOOL) definedp;
-(void) setDefined: (BOOL) ynp;

-(BOOL) deferredp;
-(void) setDeferred: (BOOL) ynp;

-(otm_qualifiers) protection;
-(void) setProtection: (otm_qualifiers) prot;

-(otm_qualifiers) redo;
-(void) setRedo: (otm_qualifiers) redo;

-(BOOL) staticp;
-(void) setStatic: (BOOL) ynp;

-(id) precompile;

@end
