/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMMetaRef.m,v 1.5 1998/01/05 01:13:22 tiggr Exp $  */

#import "OTMMetaRef.h"
#import "OTMMeta.h"

@implementation OTMMetaRef

+(OTMMetaRef *) metaRefWithMeta: (OTMMeta *) m
{
  return [[self gcAlloc] initWithMeta: m];
}

-(void) gcReference
{
  MARK (meta);

  [super gcReference];
}

-initWithMeta: (OTMMeta *) m
{
  if (![super initWithType: (id) m])
    return nil;

  meta = m;

  return self;
}

-(id) outputReference
{
  return [[meta structure] referenceName];
}

-(id) precompile
{
  if (![self declaredp])
    {
      [self setDeclared: YES];

      meta = [meta precompile];
      formac (of, @"extern %@ *%@;\n", [meta outputTypeName],
	      [self outputReference]);
    }

  return self;
}

-(id <TLString>) result
{
  return [self outputReference];
}

@end
