/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMExpr.h,v 1.31 1998/01/05 01:12:50 tiggr Exp $  */

#import "OTMTop.h"

@class OTMType, OTMTuple;

@protocol OTMExpr

-(OTMType *) type;

@end

@interface OTMExpr: OTMTop <OTMExpr>
{
  /* The type of this expression.  */
  OTMType *type;
}

/* Designated initializer.  */
-(id) initWithType: (OTMType *) t;

/* Resolve the receiving expression.  EXPECTED is a list of allowable
   types.  TO, if not nil (and not EXPECTED), is the type to which the
   returned type must be convertible; it indicates a cast surrounding the
   receiving expression.  INDEX is the index of the actual type to be
   retrieved from the types in EXPECTED and TO.

   Iff !EXPECTED, return a list of possible types the expression could
   have.  Iff EXPECTED return a list of those types in EXPECTED which
   actually could match (at the proper index, of course).  The order of
   the elements in the list returned should equal their order in EXPECTED.
   CXT is the context (for actualSelf) of the type.  */
-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index;

-(void) compile;

-(id <TLString>) exprName;

/* Do everything neccessary for the receiving expression to be added to
   the current compound, like emitting declarations of static methods and
   of selectors.  */
-(id) precompile;

/* Eleiminate any OLD expressions by evaluating the value and returning
   it.  */
-(id) oldsEliminated;

/* Return the replacement of the receiving part of a method condition for
   the new overriding METHOD.  */
-(id) conditionCopyFor: (OTMCustomMethod *) method;

-(void) compileAssignment: (OTMExpr *) rhs;

-(void) compileAssignmentToTuple: (OTMTuple *) lhs;

-(int) flatElementCount;

-(BOOL) isTuple;

/* Return the offending object making the receiving expression an invalid
   LHS.  */
-(OTMExpr *) lhsInvalid;

/* Return, in the output language, the result of this expression.  For
   tuple typed expressions, this returns the first tuple field.  */
-(id <TLString>) result;

/* Return, in the output language, a reference to this expression.  */
-(id) outputReference;

-(void) setType: (id) type;

/* Check the receiving expression, which should be a variable or a tuple
   of them, for not redeclaring anything already present in the method M.
   Return YES iff one of the variables' type is dynamic.  */
-(BOOL) checkProperArgument: (OTMMethod *) m;

-(OTMExpr *) tupleSingleElement;

-(void) declareReturnArguments: (int) n;

#ifdef OTMEXPR_DECLARE_PRIVATE_METHODS

#endif

@end
