/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMDynamicType.h,v 1.4 1998/01/05 01:12:42 tiggr Exp $  */

#import "OTMType.h"

@class OTMDynamicType, OTMInvocation;

/* The single instance of the dynamic type.  */
extern OTMDynamicType *the_dynamic_type;

@interface OTMDynamicType: OTMType
{
}

+(void) dumpInfo: (id <TLOutputStream>) inf;

+(void) init;

+(void) addInvocation: (OTMInvocation *) inv
    toDynamicSelector: (LTTSelector *) sel;

+(LTTSelector *) selectorForInvocation: (OTMInvocation *) inv
		     ofDynamicSelector: (LTTSelector *) sel;

@end
