/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMCustomMethod.m,v 1.65 1998/03/22 18:38:59 tiggr Exp $  */

#define OTMCUSTOMMETHOD_DECLARE_PRIVATE_METHODS
#import "OTMCustomMethod.h"
#import "OTMArgument.h"
#import "OTMBasic.h"
#import "OTMCompound.h"
#import "OTMDynamicType.h"
#import "OTMExtension.h"
#import "OTMForeignType.h"
#import "OTMInvocation.h"
#import "OTMMeta.h"
#import "OTMTuple.h"
#import "OTMType.h"
#import "OTMTypeTuple.h"
#import "OTMVariable.h"
#import "global.h"

@implementation OTMCustomMethod

-(void) addActualArgsFrom: (OTMExpr *) e to: (id) str
{
  if ([e isTuple])
    {
      TLVector *elts = [(OTMTuple *) e elements];
      int i, n = [elts length];

      for (i = 0; i < n; i++)
	[self addActualArgsFrom: [elts _elementAtIndex: i] to: str];
    }
  else if ([e type] != basic_type[BT_VOID])
    formac (str, @", %@", [e result]);
}

-(void) addActualOutArgsFrom: (OTMExpr *) e to: (id) str
{
  if ([e isTuple])
    {
      TLVector *elts = [(OTMTuple *) e elements];
      int i, n = [elts length];

      for (i = 0; i < n; i++)
	[self addActualOutArgsFrom: [elts _elementAtIndex: i] to: str];
    }
  else
    formac (str, @", &%@", [e result]);
}

-(OTMVariable *) argumentNamed: (id <TLString>) nm
{
  OTMVariable *arg = [super argumentNamed: nm];

  if (!arg && return_vars && !body)
    {
      TLVector *vec = [return_vars elements];
      int i, n = [vec length];

      /* XXX Nested tuples?  Should have an ArgumentTuple.  */
      for (i = 0; i < n; i++)
	{
	  OTMVariable *t = [vec _elementAtIndex: i];

	  if ([(id) nm equal: [t variableName]])
	    return t;
	}
    }

  return arg;
}

-(OTMArgument *) argumentNumbered: (int) x
{
  OTMArgument *arg = [super argumentNumbered: x];

  if (!arg)
    arg = [return_vars argumentNumbered: x];

  return arg;
}


-(OTMCompound *) body
{
  return body;
}

-(void) compile
{
  id previous_context, previous_method;

  if ([self deferredp] || [self redo] == OQ_REDECLARE)
    return;

  [self precompile];

  previous_context = output_current_context;
  previous_method = output_current_method;

  output_current_context = [[extension structure] meta];
  output_current_method = self;

  formac (of, @"\n/* Start of %@.  */\n", method_name (self, 0));

  [self compileDeclaration];

  formac (of, @"\n");

  if (foreign)
    formac (of, @";");
  else
    {
      if (!body)
	ABORT ();
      [body compile];
    }

  formac (of, @"\n/* End of %@.  */\n\n", method_name (self, 0));

  output_current_context = previous_context;
  output_current_method = previous_method;
}

-(void) compileExtensionPointerDefinitions
{
  if (uses_thread_locals)
    formac (of, @"%@char *_th_locals = trt_thread_get_local_data ();",
	    [self nl]);

#if CACHE_EXTENSION_POINTER
  if (declared_extension_pointers)
    {
      id <TLEnumerator> e = [declared_extension_pointers enumerator];
      OTMExtension *x;

      while ((x = [e nextObject]))
	formac (of, @"%@%@%@ = %@;", [self nl],
		TO_EXT_POINTER_PREFIX, [[x structure] outputName],
		[x outputOffsetFrom: [[extension structure] meta]]);
    }
#endif
}

#if CACHE_EXTENSION_POINTER
-(void) declareExtensionPointer: (OTMExtension *) ext
{
  if (!declared_extension_pointers)
    ASGN_IVAR (declared_extension_pointers, [TLSet set]);

  if (![declared_extension_pointers member: ext])
    {
      [declared_extension_pointers addElement: ext];
      [body addVariable:
	    [CO_OTMVariable variableWithName:
	     formac (nil, @"%@%@", TO_EXT_POINTER_PREFIX,
		     [[ext structure] outputName])
	     type: [CO_OTMForeignType foreignTypeWithString:
		    formac (nil, @"struct %@ *",
			    [[ext structure] outputExtensionStructName])]]];
    }
}
#endif

-(id <TLString>) foreign
{
  return foreign;
}

-(BOOL) haveReturnStatement
{
  return !!return_label;
}

-(void) gcReference
{
  MARK (foreign);
  MARK (body);
  MARK (precondition);
  MARK (postcondition);
  MARK (declared_extension_pointers);
  MARK (referencing_args);
  MARK (return_value);
  MARK (return_vars);
  MARK (return_label);

  [super gcReference];
}

-(OTMLoop *) loopForContinue: (int) level
{
  error (@"continue not within loop");
  return NULL;
}

-(id) outputCast: (id) s forInvocation: (OTMInvocation *) inv
{
  int i, n = [arguments length], implicit = [self implicitArguments];
  OTMType *rcv = [[[inv receiver] type] actualSelf: [current_either semantics]];
  OTMType *t = [inv type];
  BOOL first = NO;

  s = formac (s, @"%@ (*) (", [[t tupleFirstFlatElement] outputTypeName]);

  if (implicit)
    {
      if (flag_super == LOOKUP_SEND && [inv super])
	formac (s, @"void *, ");
      formac (s, @"void *, selector");
    }
  else if (!n)
    return formac (s, @"void)");
  else
    first = YES;

  for (i = implicit; i < n; i++)
    {
      OTMType *at = [(OTMExpr *) [arguments _elementAtIndex: i] type];

      if (at == the_dynamic_type)
	at = [[[inv arguments] _elementAtIndex: i - implicit] type];
      else
	at = [at actualSelf: rcv];

      if (at != basic_type[BT_VOID])
	{
	  if (first)
	    first = NO;
	  else
	    formac (s, @", ");

	  formac (s, @"%@", [at outputCastName]);
	}
    }

  n = [t flatElementCount];
  for (i = 1; i < n; i++)
    {
      formac (s, first ? @"void *" : @", void *");
      first = NO;
    }

  return formac (s, @")");
}

-(id) outputStartOfInvocation: (OTMInvocation *) inv
{
  LTTMeta *sup = [inv super] ? [[inv super] structure] : nil;
  id rcv = [[inv receiver] result];
  id <TLString> tom_state_name;
  LTTMeta *rcv_meta;
  id s = nil;
  id sl_name;
  id actual_sel;

  actual_sel = (dynamic_typing
		? [CO_OTMDynamicType selectorForInvocation: inv
				  ofDynamicSelector: [self selector]]
		: [self selector]);

  sl_name = [actual_sel outputDefinitionName];

  rcv_meta = [(OTMMeta *) [[[inv receiver] type]
			   actualSelf: [output_current_context semantics]]
	      structure];
  tom_state_name = ([rcv_meta classp] ? tom_c_state_field_name
		    : tom_i_state_field_name);

  if (sup)
    {
      if (flag_super == LOOKUP_LOOKUP)
	s = formac (nil, @"((%@) (trt_lookup_super (%@ %@, &%@))) (",
		    [self outputCast: nil forInvocation: inv],
		    @"(struct trt_class *)",
		    [rcv_meta outputSuperReference: sup], sl_name);
      else if (flag_super == LOOKUP_SEND)
	{
	  // XXX trt_send_super can not work.
	  // Fri Oct  4 21:51:51 1996, tiggr@jaguar.ics.ele.tue.nl
	  abort ();
	  s = formac (nil, @"((%@) trt_send_super) (%@, ",
		      [self outputCast: nil forInvocation: inv],
		      [rcv_meta outputSuperReference: sup]);
	}
      else /* (flag_lookup == LOOKUP_DIRECT) */
	s = formac (nil, @"((%@) (%@->mdt"
		    @"->b[%@.sel_id / TRT_BUCKET_SIZE]"
		    @"->m[%@.sel_id %% TRT_BUCKET_SIZE])) (",
		    [self outputCast: nil forInvocation: inv],
		    [rcv_meta outputSuperReference: sup], sl_name, sl_name);
    }
  else if (flag_lookup == LOOKUP_LOOKUP)
    s = formac (nil, @"((%@) (trt_lookup (%@ %@, &%@))) (",
		[self outputCast: nil forInvocation: inv],
		@"(struct trt_instance *)", rcv, sl_name);
  else if (flag_lookup == LOOKUP_SEND)
    s = formac (nil, @"((%@) trt_send) (",
		[self outputCast: nil forInvocation: inv]);
  else /* (flag_lookup == LOOKUP_DIRECT) */
    s = formac (nil, @"((%@) ((struct trt_instance *) %@)->%@->mdt"
		@"->b[%@.sel_id / TRT_BUCKET_SIZE]"
		@"->m[%@.sel_id %% TRT_BUCKET_SIZE]) (",
		[self outputCast: nil forInvocation: inv],
		rcv, TO_NAME_ISA, sl_name, sl_name);

  return formac (s, @"%@, &%@", rcv, sl_name);
}

-(id) precompile
{
  if (![self declarationOutputp])
    {
      [self setDeclarationOutputP: YES];
      [[[self selector] semantics] compileDeclaration];
      [super precompile];
    }

  return self;
}

-(TLVector *) referencingArguments
{
  return referencing_args;
}

-(void) resolveIdentifiers: (OTMMeta *) meta
{
  if (precondition)
    precondition = [precondition resolveInContext: meta];
  if (postcondition)
    postcondition = [postcondition resolveInContext: meta];

  [super resolveIdentifiers: meta];
}

-(id) resultOfInvocation: (OTMInvocation *) inv
{
  TLVector *args = [inv arguments];
  id s = [self outputStartOfInvocation: inv];
  int i, n = [args length];

  for (i = 0; i < n; i++)
    [self addActualArgsFrom: [args _elementAtIndex: i] to: s];

  return formac (s, @")");
}

-(id) resultOfInvocation: (OTMInvocation *) inv
		 toTuple: (OTMTuple *) tup
{
  TLVector *args = [inv arguments];
  TLVector *out_actuals = [tup elements];
  id s = [self outputStartOfInvocation: inv];
  int i, n;

  for (i = 0, n = [args length]; i < n; i++)
    [self addActualArgsFrom: [args _elementAtIndex: i] to: s];

  /* Output the out-arguments to the method.  */
  for (i = 1, n = [out_actuals length]; i < n; i++)
    [self addActualOutArgsFrom: [out_actuals _elementAtIndex: i] to: s];

  return formac (s, @")");
}

-(OTMExpr *) returnValue
{
  return return_value;
}

-(OTMLabel *) setHaveReturnStatement
{
  if (!return_label)
    return_label = [CO_OTMLabel new];

  return return_label;
}

-(void) setReturnValue: (OTMExpr *) e
{
  return_value = [e tupleSingleElement];
}

-(OTMTuple *) returnVariables
{
  return return_vars;
}

-(void) setReturnVariables: (OTMTuple *) tuple
{
  if ((id) [return_type tupleSingleElement] == basic_type[BT_VOID])
    return;

  {
    TLVector *te = tuple ? [tuple elements] : nil;
    int i, tn = 1, n = te ? [te length] : 0;
    OTMType *t = return_type;
    TLVector *tv = nil;

    if ([return_type isTuple])
      {
	tv = [(OTMTypeTuple *) return_type elements];
	tn = [tv length];
      }

    if (tuple && n != tn)
      error (@"count mismatch in return value names");
    else
      {
	if (!tuple)
	  {
	    tuple = [OTMTuple new];
	    te = [tuple elements];
	  }

	first_return_arg = next_arg;
	for (i = 0; i < tn; i++)
	  {
	    TLString *s = n ? [te _elementAtIndex: i] : nil;
	    OTMArgument *arg = nil;

	    if (tn != 1)
	      t = [tv _elementAtIndex: i];

	    if (s)
	      arg = (id) [self argumentNamed: s];

	    if (!arg)
	      {
		if (s)
		  arg = [CO_OTMArgument variableWithName: s type: t
					number: next_arg++];
		else
		  arg = [CO_OTMArgument temporaryVariableWithType: t
					number: next_arg++];
	      }

	    if (n)
	      [te _replaceElementAtIndex: i by: arg];
	    else
	      [te addElement: arg];
	  }
	return_vars = tuple;
      }
  }
}

-(BOOL) isReturnVariable: (OTMArgument *) v
{
  return [v argumentNumber] >= first_return_arg;
}

-(void) setBody: b
{
  if (body)
    ABORT ();

  ASGN_IVAR (body, b);
  if (return_vars)
    [return_vars declareReturnArguments: first_return_arg];
}

-(void) setBreakValue: (OTMExpr *) e
{
  error_for (e, @"break not in loop");
}

-(void) setHaveStackReferences: (OTMVariable *) v
{
  if (!referencing_args)
    referencing_args = [CO_TLVector vector];

  [referencing_args addElement: v];
}

-(void) setForeign: (id <TLString>) f
{
  ASGN_IVAR (foreign, f);
}

-(void) setNeedLocalPointer
{
  uses_thread_locals = 1;
}

-(OTMExpr *) precondition
{
  return precondition;
}

-(void) setPrecondition: (OTMExpr *) prec
{
  ASGN_IVAR (precondition, prec);
}

-(OTMExpr *) postcondition
{
  return postcondition;
}

-(void) setPostcondition: (OTMExpr *) post
{
  ASGN_IVAR (postcondition, post);
}

-(void) setStackProtected
{
  stack_protected = YES;
}

-(BOOL) stackProtected
{
  return stack_protected;
}

-(TLVector *) collectPreconditions
{
  return [(OTMMeta *) [[[extension structure] meta] semantics]
	  collectConditions: 1 for: self];
}

-(TLVector *) collectPostconditions
{
  return [(OTMMeta *) [[[extension structure] meta] semantics]
	  collectConditions: 0 for: self];
}

@end
