/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMConstant.h,v 1.5 1998/01/05 01:12:35 tiggr Exp $  */

#import "OTMExpr.h"

@class OTMExtension;

@interface OTMConstant: OTMExpr
{
  OTMExtension *ext;

  id <TLString> name;

  OTMExpr *value;
}

+(OTMConstant *) constantWithExtension: (OTMExtension *) x
				  name: (id <TLString>) n
				 value: (OTMExpr *) v;

-(void) dumpInfo: (id <TLOutputStream>) s;

-(OTMExtension *) extension;

-(OTMExpr *) value;

#ifdef OTMCONSTANT_DECLARE_PRIVATE_METHODS

-(id) initWithExtension: (OTMExtension *) x
		   name: (id <TLString>) n
		  value: (OTMExpr *) v;

#endif

@end
