/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMAlias.m,v 1.9 1998/01/05 01:11:49 tiggr Exp $  */

#define OTMALIAS_DECLARE_PRIVATE_METHODS
#import "OTMAlias.h"
#import "OTMCustomMethod.h"
#import "OTMExtension.h"
#import "OTMObjectVar.h"
#import "OTMType.h"
#import "LTTPatches.h"
#import "global.h"

@implementation OTMAlias

+(OTMAlias *) aliasWithExtension: (OTMExtension *) e
			variable: (OTMObjectVar *) orig
			    type: (OTMType *) t
		      qualifiers: (otm_qualifiers) q
{
  return [[self gcAlloc] initWithExtension: e variable: orig
			 type: t qualifiers: q];
}

-(void) compileAssignment: (OTMExpr *) rhs
{
  [value compileAssignment: rhs];
}

-(void) compileAssignmentToTuple: (OTMTuple *) lhs
{
  [value compileAssignmentToTuple: lhs];
}

-(id) elaborate
{
  value = implicit_cast (value, type);

  return [super elaborate];
}

-(id) initWithExtension: (OTMExtension *) e
	       variable: (OTMObjectVar *) orig
		   type: (OTMType *) t
	     qualifiers: (otm_qualifiers) q
{
  if (![super initWithExtension: e name: [orig variableName] value: orig])
    return nil;

  [self setQualifiers: q];
  type = t;

  return self;
}

-(OTMExpr *) lhsInvalid
{
  return nil;
}

-(id) precompile
{
  [value precompile];
  return [super precompile];
}

-(id <TLString>) result
{
  return [value result];
}

@end
