<copyright> Pointer class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Pointer.t,v 1.2 1998/01/05 01:06:56 tiggr Exp $</id>
    </copyright>

<doc> This {Pointer} class is a simple object wrapper around an object
    value.  </doc>
implementation class
Pointer: State

<doc> Hash the pointer {p}.  This hashes the pointer in a way similar to
    the {hashq} method of {All}.  </doc>
int (result)
  hash pointer p
{
<c>
  result = (tom_int) p;
</c>
}

<doc> Simple allocator.  </doc>
instance (id)
  with pointer p
{
  = [[self alloc] init p];
}

end;

implementation instance
Pointer
{
  <doc> Our value.  </doc>
  public pointer value;
}

<doc> Designated initializer.  </doc>
id (self)
  init pointer p
{
  value = p;
}

<doc> Return {YES}.  </doc>
boolean
  dump_simple_p
{
  = TRUE;
}

<doc> Compare our {value} with the {other}'s.  </doc>
boolean
  equal Pointer other
{
  = value == [other value];
}

<doc> Return the hashed pointer {value}.  </doc>
int
  hash
{
  = [isa hash value];
}

<doc> Similar to a {Number}, a {Pointer} simply outputs the {value}.
    </doc>
OutputStream
  write OutputStream s
{
  = [s print value];
}

end;
